/*
 * Decompiled with CFR 0.152.
 */
package net.paissad.tools.reqcoco.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.paissad.tools.reqcoco.maven.plugin.AbstractReqCoCoMojo;
import net.paissad.tools.reqcoco.runner.ExitStatus;
import net.paissad.tools.reqcoco.runner.ReqRunner;
import net.paissad.tools.reqcoco.runner.ReqRunnerOptions;
import net.paissad.tools.reqcoco.runner.ReqSourceType;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE, requiresProject=true, threadSafe=true, aggregator=true)
public class ReqCocoReportMojo
extends AbstractReqCoCoMojo {
    @Parameter(property="reqcoco.report.config", required=true, defaultValue="${basedir}${file.separator}reqcoco.properties")
    private String config;
    @Parameter(property="reqcoco.report.source.type", required=true, defaultValue="FILE")
    private ReqSourceType sourcetype;
    @Parameter(property="reqcoco.report.source.location", required=true)
    private String sourcelocation;
    @Parameter(property="reqcoco.report.code.source", required=true, defaultValue="${project.build.sourceDirectory}")
    private String sourceCodePath;
    @Parameter(property="reqcoco.report.code.test", required=true, defaultValue="${project.build.testSourceDirectory}")
    private String testCodePath;
    @Parameter(property="reqcoco.report.outputdir", required=true, defaultValue="${project.build.directory}${file.separator}reqcoco-reports")
    private File outputdir;
    @Parameter(property="reqcoco.report.htmlreport", required=false, defaultValue="true")
    private boolean htmlreport;
    @Parameter(property="reqcoco.report.excelreport", required=false, defaultValue="true")
    private boolean excelreport;
    @Parameter(property="reqcoco.report.name", required=false)
    private String reportname;
    @Parameter(readonly=true, required=false, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        String format = "############# %-15s : %s";
        this.getLog().debug((CharSequence)"======================= ReqCoCo parameters =====================================");
        this.getLog().debug((CharSequence)String.format(format, "config", this.config));
        this.getLog().debug((CharSequence)String.format(format, "sourcetype", this.sourcetype));
        this.getLog().debug((CharSequence)String.format(format, "sourcelocation", this.sourcelocation));
        this.getLog().debug((CharSequence)String.format(format, "outputdir", this.outputdir));
        this.getLog().debug((CharSequence)String.format(format, "sourceCodePath", this.sourceCodePath));
        this.getLog().debug((CharSequence)String.format(format, "testCodePath", this.testCodePath));
        this.getLog().debug((CharSequence)String.format(format, "htmlreport", this.htmlreport));
        this.getLog().debug((CharSequence)String.format(format, "excelreport", this.excelreport));
        this.getLog().debug((CharSequence)String.format(format, "reportname", this.reportname));
        this.getLog().debug((CharSequence)"================================================================================");
        try {
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList("--config", this.config, "--input-type", this.sourcetype.name(), "--input", this.sourcelocation, "--output", this.outputdir.toString()));
            if (!StringUtils.isBlank((CharSequence)this.reportname)) {
                arguments.add("--report-name");
                arguments.add(this.reportname);
            }
            ReqRunner reqRunner = new ReqRunner();
            int parseArgsStatus = reqRunner.parseArguments(arguments.toArray(new String[arguments.size()]));
            if (ExitStatus.OK.getCode() == parseArgsStatus) {
                this.getLog().info((CharSequence)"Running the requirements code coverage report generator");
                ReqRunnerOptions options = reqRunner.getOptions();
                if (!StringUtils.isBlank((CharSequence)options.getSourceCodePath())) {
                    this.getLog().warn((CharSequence)"The value of 'code.source.path' will not be used. It must be defined into the pom.xml");
                }
                if (!StringUtils.isBlank((CharSequence)options.getTestCodePath())) {
                    this.getLog().warn((CharSequence)"The value of 'code.test.path' will not be used. It must be defined into the pom.xml");
                }
                this.getLog().debug((CharSequence)("Setting the source code path to -> " + this.sourceCodePath));
                options.setSourceCodePath(this.sourceCodePath);
                this.getLog().debug((CharSequence)("Setting the test code path to ->" + this.testCodePath));
                options.setTestCodePath(this.testCodePath);
                options.setReportConsole(false);
                options.setReportHtml(this.htmlreport);
                options.setReportExcel(this.excelreport);
                int generateReportsStatus = reqRunner.generateReports();
                if (ExitStatus.OK.getCode() != generateReportsStatus) {
                    String errMsg = "The return code status while generating the reports is : " + generateReportsStatus;
                    this.getLog().error((CharSequence)errMsg);
                    throw new MojoExecutionException(errMsg);
                }
            } else {
                String errMsg = "The ReqRunner program returned an exit code of " + parseArgsStatus + ". The arguments are : " + arguments;
                this.getLog().error((CharSequence)errMsg);
                throw new MojoExecutionException(errMsg);
            }
            this.getLog().info((CharSequence)"Finished generating requirements coverage report");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Error while generating the requirements code coverage", e);
        }
    }
}

