/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations.internal.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.ozwolf.mongo.migrations.internal.util.strict.StrictOperator;

public class StrictJsonUtils {
    public static Map<String, Object> interpolate(Map<String, Object> command) {
        StrictJsonUtils.interpolateLeaf(command);
        return command;
    }

    private static void interpolateLeaf(Map<String, Object> leaf) {
        try {
            for (String key : leaf.keySet()) {
                Object value = leaf.get(key);
                StrictOperator operator = StrictOperator.findFor(value).orElse(null);
                if (operator != null) {
                    leaf.put(key, operator.interpolate(value));
                    continue;
                }
                ValueType type = StrictJsonUtils.getType(value);
                switch (type) {
                    case OBJECT: {
                        StrictJsonUtils.interpolateLeaf((Map)value);
                        break;
                    }
                    case LITERAL_LIST: {
                        leaf.put(key, ((List)value).stream().map(StrictJsonUtils::interpolated).collect(Collectors.toList()));
                        break;
                    }
                    case OBJECT_LIST: {
                        ((List)value).forEach(StrictJsonUtils::interpolateLeaf);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object interpolated(Object value) {
        return StrictOperator.findFor(value).map(o -> o.interpolate(value)).orElse(value);
    }

    private static ValueType getType(Object value) {
        if (value instanceof List) {
            List l = (List)value;
            return StrictJsonUtils.isObjectList(l) ? ValueType.OBJECT_LIST : ValueType.LITERAL_LIST;
        }
        if (value instanceof Map) {
            return ValueType.OBJECT;
        }
        return ValueType.LITERAL;
    }

    private static boolean isObjectList(List collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Object first = collection.get(0);
        return first instanceof Map;
    }

    private static enum ValueType {
        OBJECT,
        LITERAL,
        OBJECT_LIST,
        LITERAL_LIST;

    }
}

