/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations.internal.factory;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Optional;
import net.ozwolf.mongo.migrations.exception.MongoTrekFailureException;
import net.ozwolf.mongo.migrations.internal.domain.MigrationCommands;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class MigrationCommandsFactory {
    private static final ObjectMapper MAPPER = new YAMLMapper();

    public MigrationCommands getCommands(String migrationsFile) throws MongoTrekFailureException {
        try {
            String source = MigrationCommandsFactory.load(migrationsFile).orElseThrow(() -> new MongoTrekFailureException(new IllegalArgumentException(String.format("Could not find migrations file [ %s ] on classpath or file system.", migrationsFile))));
            return (MigrationCommands)MAPPER.readValue(source, MigrationCommands.class);
        }
        catch (IOException e) {
            throw new MongoTrekFailureException(e);
        }
    }

    private static Optional<String> load(String migrationsFile) throws MongoTrekFailureException {
        URL url = MigrationCommandsFactory.class.getClassLoader().getResource(migrationsFile);
        File file = new File(migrationsFile);
        try {
            if (url != null) {
                return Optional.ofNullable(IOUtils.toString((InputStream)url.openStream(), (Charset)Charset.defaultCharset()));
            }
            if (file.exists()) {
                return Optional.ofNullable(FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new MongoTrekFailureException(e);
        }
    }
}

