/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations.internal.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.ozwolf.mongo.migrations.internal.domain.MigrationCommand;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize
@JsonIgnoreProperties(ignoreUnknown=true)
public class MigrationCommands {
    private final String schemaVersionCollection;
    private final List<MigrationCommand> migrations;

    @JsonCreator
    public MigrationCommands(@JsonProperty(value="collectionName") String schemaVersionCollection, @JsonProperty(value="migrations") List<MigrationCommand> migrations) {
        this.schemaVersionCollection = schemaVersionCollection;
        this.migrations = Optional.ofNullable(migrations).orElse(new ArrayList());
    }

    public Optional<String> getSchemaVersionCollection() {
        return Optional.ofNullable(StringUtils.trimToNull((String)this.schemaVersionCollection));
    }

    public List<MigrationCommand> getMigrations() {
        return this.migrations;
    }

    public boolean hasMigrations() {
        return !this.migrations.isEmpty();
    }
}

