/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import net.ozwolf.mongo.migrations.MongoTrekState;
import net.ozwolf.mongo.migrations.exception.MongoTrekFailureException;
import net.ozwolf.mongo.migrations.internal.dao.DefaultSchemaVersionDAO;
import net.ozwolf.mongo.migrations.internal.dao.SchemaVersionDAO;
import net.ozwolf.mongo.migrations.internal.domain.Migration;
import net.ozwolf.mongo.migrations.internal.domain.MigrationCommands;
import net.ozwolf.mongo.migrations.internal.factory.MigrationCommandsFactory;
import net.ozwolf.mongo.migrations.internal.service.MigrationsService;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoTrek {
    private final MongoClient mongo;
    private final MongoDatabase database;
    private final String migrationsFile;
    private final boolean providedDatabase;
    private SchemaVersionDAO schemaVersionDAO;
    private MigrationsService migrationsServices;
    private MigrationCommandsFactory commandsFactory;
    private String schemaVersionCollection;
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoTrek.class);
    private static final String DEFAULT_SCHEMA_VERSION_COLLECTION = "_schema_version";

    public MongoTrek(String migrationsFile, String uri) {
        this.migrationsFile = migrationsFile;
        MongoClientURI clientURI = new MongoClientURI(uri);
        if (clientURI.getDatabase() == null) {
            throw new IllegalArgumentException("URI [ " + uri + " ] must contain a database schema to connect to.");
        }
        this.mongo = new MongoClient(clientURI);
        this.database = this.mongo.getDatabase(clientURI.getDatabase());
        this.providedDatabase = false;
        this.schemaVersionCollection = DEFAULT_SCHEMA_VERSION_COLLECTION;
    }

    public MongoTrek(String migrationsFile, MongoDatabase database) {
        this.migrationsFile = migrationsFile;
        this.mongo = null;
        this.database = database;
        this.providedDatabase = true;
        this.schemaVersionCollection = DEFAULT_SCHEMA_VERSION_COLLECTION;
    }

    public void setSchemaVersionCollection(String collectionName) {
        this.schemaVersionCollection = collectionName;
    }

    public MongoTrekState migrate() throws MongoTrekFailureException {
        MongoTrekState mongoTrekState;
        MongoTrekState.Pending pending;
        AtomicInteger successfulCount;
        Instant start;
        MongoTrekState state;
        MigrationCommands commands;
        block9: {
            LOGGER.info("DATABASE MIGRATIONS");
            commands = this.commandsFactory().getCommands(this.migrationsFile);
            commands.getSchemaVersionCollection().ifPresent(n -> {
                if (this.schemaVersionCollection.equalsIgnoreCase(DEFAULT_SCHEMA_VERSION_COLLECTION)) {
                    this.schemaVersionCollection = n;
                }
            });
            state = this.migrationsService().getState(commands);
            if (!commands.hasMigrations()) {
                LOGGER.info("   No migrations to apply.");
                return state;
            }
            start = Instant.now();
            successfulCount = new AtomicInteger(0);
            pending = state.getPending();
            if (pending.hasPendingMigrations()) break block9;
            LOGGER.info("   No migrations to apply.");
            MongoTrekState mongoTrekState2 = state;
            Instant finish = Instant.now();
            LOGGER.info(String.format(">>> [ %d ] migrations applied in [ %d seconds ] <<<", successfulCount.get(), Duration.between(start, finish).getSeconds()));
            if (!this.providedDatabase) {
                this.mongo.close();
            }
            return mongoTrekState2;
        }
        try {
            this.logStatus("migrate", state.getCurrentVersion());
            LOGGER.info(String.format("       Applying : [ %s ] -> [ %s ]", pending.getNextPendingVersion(), pending.getLastPendingVersion()));
            LOGGER.info("     Migrations :");
            pending.getMigrations().forEach(m -> this.applyMigration(successfulCount, (Migration)m));
            mongoTrekState = this.migrationsService().getState(commands);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Error applying migration(s)", (Throwable)e);
                throw new MongoTrekFailureException(e);
            }
            catch (Throwable throwable) {
                Instant finish = Instant.now();
                LOGGER.info(String.format(">>> [ %d ] migrations applied in [ %d seconds ] <<<", successfulCount.get(), Duration.between(start, finish).getSeconds()));
                if (!this.providedDatabase) {
                    this.mongo.close();
                }
                throw throwable;
            }
        }
        Instant finish = Instant.now();
        LOGGER.info(String.format(">>> [ %d ] migrations applied in [ %d seconds ] <<<", successfulCount.get(), Duration.between(start, finish).getSeconds()));
        if (!this.providedDatabase) {
            this.mongo.close();
        }
        return mongoTrekState;
    }

    public MongoTrekState status() throws MongoTrekFailureException {
        return this.status(false);
    }

    public MongoTrekState status(boolean logStatus) throws MongoTrekFailureException {
        if (logStatus) {
            LOGGER.info("DATABASE MIGRATIONS");
        }
        MigrationCommands commands = this.commandsFactory().getCommands(this.migrationsFile);
        MongoTrekState state = this.migrationsService().getState(commands);
        try {
            if (logStatus) {
                this.logStatus("status", state.getCurrentVersion());
                LOGGER.info("     Migrations :");
                state.getMigrations().forEach(this::reportMigration);
            }
            MongoTrekState mongoTrekState = state;
            return mongoTrekState;
        }
        catch (Exception e) {
            if (logStatus) {
                LOGGER.error("Error in commands and cannot provide status", (Throwable)e);
            }
            throw new MongoTrekFailureException(e);
        }
        finally {
            if (!this.providedDatabase) {
                this.mongo.close();
            }
        }
    }

    private void logStatus(String action, String currentVersion) {
        LOGGER.info(String.format("       Database : [ %s ]", this.database.getName()));
        LOGGER.info(String.format(" Schema Version : [ %s ]", this.schemaVersionCollection));
        LOGGER.info(String.format("         Action : [ %s ]", action));
        LOGGER.info(String.format("Current Version : [ %s ]", currentVersion));
    }

    private void applyMigration(AtomicInteger successfulCount, Migration migration) {
        try {
            LOGGER.info(String.format("       %s : %s", migration.getVersion(), migration.getDescription()));
            this.schemaVersionDAO().save(migration.running());
            Document result = migration.getCommand().migrate(this.database);
            this.schemaVersionDAO().save(migration.successful(result));
            successfulCount.incrementAndGet();
        }
        catch (Exception e) {
            this.schemaVersionDAO().save(migration.failed(e));
            throw e;
        }
    }

    private void reportMigration(Migration migration) {
        LOGGER.info(String.format("       %s : %s", migration.getVersion(), migration.getDescription()));
        LOGGER.info(String.format("          Tags: %s", migration.getTags()));
    }

    private DB connectTo(MongoClientURI uri) {
        MongoClient mongo = new MongoClient(uri);
        return mongo.getDB(uri.getDatabase());
    }

    private MigrationsService migrationsService() {
        if (this.migrationsServices == null) {
            this.migrationsServices = new MigrationsService(this.schemaVersionDAO());
        }
        return this.migrationsServices;
    }

    private SchemaVersionDAO schemaVersionDAO() {
        if (this.schemaVersionDAO == null) {
            this.schemaVersionDAO = new DefaultSchemaVersionDAO((MongoCollection<Document>)this.database.getCollection(this.schemaVersionCollection));
        }
        return this.schemaVersionDAO;
    }

    private MigrationCommandsFactory commandsFactory() {
        if (this.commandsFactory == null) {
            this.commandsFactory = new MigrationCommandsFactory();
        }
        return this.commandsFactory;
    }
}

