/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations.internal.dao;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.ozwolf.mongo.migrations.internal.dao.SchemaVersionDAO;
import net.ozwolf.mongo.migrations.internal.domain.Migration;
import net.ozwolf.mongo.migrations.internal.domain.MigrationStatus;
import org.bson.Document;

public class DefaultSchemaVersionDAO
implements SchemaVersionDAO {
    private final MongoCollection<Document> collection;

    public DefaultSchemaVersionDAO(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    @Override
    public List<Migration> findAll() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        this.collection.find().forEach(d -> migrations.add(new Migration(d.getString((Object)"version"), d.getString((Object)"description"), d.getString((Object)"author"), Optional.ofNullable(d.getDate((Object)"started")).map(Date::toInstant).orElse(null), Optional.ofNullable(d.getDate((Object)"finished")).map(Date::toInstant).orElse(null), MigrationStatus.valueOf(d.getString((Object)"status")), d.getString((Object)"failureMessage"), (Map)d.get((Object)"result", Document.class))));
        return migrations;
    }

    @Override
    public void save(Migration migration) {
        Document d = new Document("version", (Object)migration.getVersion()).append("description", (Object)migration.getDescription()).append("author", (Object)migration.getAuthor()).append("started", Optional.ofNullable(migration.getStarted()).map(Date::from).orElse(null)).append("finished", Optional.ofNullable(migration.getFinished()).map(Date::from).orElse(null)).append("status", (Object)migration.getStatus().name()).append("failureMessage", (Object)migration.getFailureMessage()).append("result", migration.getResult());
        this.collection.replaceOne(Filters.eq((String)"version", (Object)migration.getVersion()), (Object)d, new ReplaceOptions().upsert(true));
    }

    @Override
    public Optional<Migration> findLastSuccessful() {
        return this.findAll().stream().filter(m -> m.getStatus() == MigrationStatus.Successful).sorted(Comparator.comparing(Migration::getVersion)).reduce((p, c) -> c);
    }
}

