/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations.internal.util.strict;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.ozwolf.mongo.migrations.internal.util.strict.interpolator.DateInterpolator;
import net.ozwolf.mongo.migrations.internal.util.strict.test.DateTest;

public enum StrictOperator {
    DATE(new DateTest(), new DateInterpolator());

    private final Predicate<Object> tester;
    private final Function<Object, Object> interpolator;

    private StrictOperator(Predicate<Object> tester, Function<Object, Object> interpolator) {
        this.tester = tester;
        this.interpolator = interpolator;
    }

    public Object interpolate(Object value) {
        return this.interpolator.apply(value);
    }

    public static Optional<StrictOperator> findFor(Object value) {
        for (StrictOperator operator : StrictOperator.values()) {
            if (!operator.tester.test(value)) continue;
            return Optional.of(operator);
        }
        return Optional.empty();
    }
}

