/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations.internal.service;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.ozwolf.mongo.migrations.MongoTrekState;
import net.ozwolf.mongo.migrations.exception.DuplicateVersionException;
import net.ozwolf.mongo.migrations.internal.dao.SchemaVersionDAO;
import net.ozwolf.mongo.migrations.internal.domain.Migration;
import net.ozwolf.mongo.migrations.internal.domain.MigrationCommands;

public class MigrationsService {
    private final SchemaVersionDAO schemaVersionDAO;

    public MigrationsService(SchemaVersionDAO schemaVersionDAO) {
        this.schemaVersionDAO = schemaVersionDAO;
    }

    public MongoTrekState getState(MigrationCommands commands) {
        return new MongoTrekState(this.getFullState(commands));
    }

    private List<Migration> getFullState(MigrationCommands commands) throws DuplicateVersionException {
        List<Migration> alreadyRun = this.schemaVersionDAO.findAll();
        List<Migration> commandMigrations = commands.getMigrations().stream().map(Migration::new).collect(Collectors.toList());
        this.checkForDuplicateVersions(commandMigrations);
        return commandMigrations.stream().map(MigrationsService.joinWith(alreadyRun)).collect(Collectors.toList());
    }

    private void checkForDuplicateVersions(List<Migration> migrations) throws DuplicateVersionException {
        List duplicateVersions = migrations.stream().filter(m -> migrations.stream().filter(cm -> cm.getVersion().equals(m.getVersion())).count() > 1L).collect(Collectors.toList());
        if (!duplicateVersions.isEmpty()) {
            throw new DuplicateVersionException((Migration)duplicateVersions.get(0));
        }
    }

    private static Function<Migration, Migration> joinWith(List<Migration> alreadyRun) {
        return migration -> {
            Optional<Migration> found = alreadyRun.stream().filter(o -> o.getVersion().equals(migration.getVersion())).findFirst();
            return found.orElse((Migration)migration).assign(migration.getCommand());
        };
    }
}

