/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.ozwolf.mongo.migrations.internal.domain.Migration;

public class MongoTrekState {
    private final Map<String, Migration> migrations = new HashMap<String, Migration>();

    public MongoTrekState(Collection<Migration> migrations) {
        migrations.forEach(m -> this.migrations.put(m.getVersion(), (Migration)m));
    }

    public String getCurrentVersion() {
        return this.getLastSuccessfulMigration().map(Migration::getVersion).orElse("N/A");
    }

    public List<Migration> getMigrations() {
        return this.migrations.values().stream().sorted(Migration.sortByVersionAscending()).collect(Collectors.toList());
    }

    public Pending getPending() {
        List migrations = this.migrations.values().stream().filter(m -> m.isPending() || m.isFailed()).collect(Collectors.toList());
        return new Pending(migrations);
    }

    public List<Migration> getFailed() {
        return this.migrations.values().stream().filter(Migration::isFailed).collect(Collectors.toList());
    }

    public List<Migration> getApplied() {
        return this.migrations.values().stream().filter(Migration::isSuccessful).collect(Collectors.toList());
    }

    private Optional<Migration> getLastSuccessfulMigration() {
        return this.migrations.values().stream().filter(Migration::isSuccessful).min(Migration.sortByVersionDescending());
    }

    public static class Pending {
        private final List<Migration> migrations;

        private Pending(List<Migration> migrations) {
            this.migrations = migrations;
        }

        public boolean hasPendingMigrations() {
            return !this.migrations.isEmpty();
        }

        public String getNextPendingVersion() {
            return this.migrations.stream().min(Migration.sortByVersionAscending()).map(Migration::getVersion).orElse("N/A");
        }

        public String getLastPendingVersion() {
            return this.migrations.stream().min(Migration.sortByVersionDescending()).map(Migration::getVersion).orElse("N/A");
        }

        public List<Migration> getMigrations() {
            return this.migrations.stream().sorted(Migration.sortByVersionAscending()).collect(Collectors.toList());
        }
    }
}

