/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations.internal.domain;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.ozwolf.mongo.migrations.internal.domain.MigrationCommand;
import net.ozwolf.mongo.migrations.internal.domain.MigrationStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class Migration {
    private final String version;
    private final String description;
    private final String author;
    private DateTime started;
    private DateTime finished;
    private MigrationStatus status;
    private String failureMessage;
    private MigrationCommand command;
    public static final String DEFAULT_AUTHOR = "trekBot";

    public Migration(String version, String description, String author, DateTime started, DateTime finished, MigrationStatus status, String failureMessage) {
        this.version = version;
        this.description = description;
        this.author = Optional.ofNullable(author).orElse(DEFAULT_AUTHOR);
        this.started = started;
        this.finished = finished;
        this.status = status;
        this.failureMessage = failureMessage;
    }

    public Migration(MigrationCommand command) {
        this(command.getVersion(), command.getDescription(), command.getAuthor(), null, null, MigrationStatus.Pending, null);
        this.command = command;
    }

    public String getVersion() {
        return this.version;
    }

    public ComparableVersion getComparableVersion() {
        return new ComparableVersion(this.version);
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public DateTime getStarted() {
        return this.started;
    }

    public DateTime getFinished() {
        return this.finished;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public String getDuration() {
        if (this.status != MigrationStatus.Successful) {
            return "";
        }
        return String.format("%d seconds", Seconds.secondsBetween((ReadableInstant)this.started, (ReadableInstant)this.finished).getSeconds());
    }

    public MigrationStatus getStatus() {
        return this.status;
    }

    public boolean isSuccessful() {
        return this.status == MigrationStatus.Successful;
    }

    public boolean isFailed() {
        return this.status == MigrationStatus.Failed;
    }

    public boolean isPending() {
        return this.status == MigrationStatus.Pending;
    }

    public boolean isRunning() {
        return this.status == MigrationStatus.Running;
    }

    public MigrationCommand getCommand() {
        return Optional.ofNullable(this.command).orElseThrow(() -> new IllegalStateException(String.format("No command attached to migration [ %s ]", this.version)));
    }

    public Migration assign(MigrationCommand command) {
        this.command = command;
        return this;
    }

    public Migration running() {
        this.started = DateTime.now();
        this.finished = null;
        this.failureMessage = null;
        this.status = MigrationStatus.Running;
        return this;
    }

    public Migration successful() {
        this.finished = DateTime.now();
        this.status = MigrationStatus.Successful;
        return this;
    }

    public Migration failed(Exception e) {
        this.finished = null;
        this.status = MigrationStatus.Failed;
        this.failureMessage = e.getMessage();
        return this;
    }

    public String getTags() {
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(String.format("[ %s ]", this.status.name()));
        if (this.status == MigrationStatus.Successful || this.status == MigrationStatus.Failed) {
            tags.add(String.format("[ %s ]", this.started.toDateTime(DateTimeZone.getDefault()).toString("yyyy-MM-dd HH:mm:ss")));
        }
        if (this.status == MigrationStatus.Successful) {
            tags.add(String.format("[ %s ]", this.getDuration()));
        }
        if (this.status == MigrationStatus.Failed) {
            tags.add(String.format("[ ERROR: %s ]", this.failureMessage));
        }
        return StringUtils.join(tags, (String)" ");
    }

    public String toString() {
        return String.format("version = <%s>, description = <%s>, author = <%s>, status = <%s>", new Object[]{this.version, this.description, this.author, this.status});
    }

    public static Comparator<Migration> sortByVersionAscending() {
        return (m1, m2) -> m1.getComparableVersion().compareTo(m2.getComparableVersion());
    }

    public static Comparator<Migration> sortByVersionDescending() {
        return (m1, m2) -> m2.getComparableVersion().compareTo(m1.getComparableVersion());
    }
}

