/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations.internal.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.bson.conversions.Bson;

@JsonDeserialize
@JsonIgnoreProperties(ignoreUnknown=true)
public class MigrationCommand {
    private final String version;
    private final String description;
    private final String author;
    private final BasicDBObject command;

    @JsonCreator
    public MigrationCommand(@JsonProperty(value="version") String version, @JsonProperty(value="description") String description, @JsonProperty(value="author") String author, @JsonProperty(value="command") Map<String, Object> command) {
        if (StringUtils.trimToNull((String)version) == null || StringUtils.trimToNull((String)description) == null || command == null) {
            throw new IllegalStateException("A migration command requires at least a version, description and a command!");
        }
        this.version = version;
        this.description = description;
        this.author = Optional.ofNullable(author).orElse("trekBot");
        this.command = new BasicDBObject(command);
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public DBObject getCommand() {
        return this.command;
    }

    public void migrate(MongoDatabase database) {
        database.runCommand((Bson)this.command);
    }
}

