/*
 * Decompiled with CFR 0.152.
 */
package net.ozwolf.mongo.migrations.internal.dao;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.ozwolf.mongo.migrations.internal.dao.SchemaVersionDAO;
import net.ozwolf.mongo.migrations.internal.domain.Migration;
import net.ozwolf.mongo.migrations.internal.domain.MigrationStatus;
import org.bson.Document;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;

public class DefaultSchemaVersionDAO
implements SchemaVersionDAO {
    private final MongoCollection<Document> collection;

    public DefaultSchemaVersionDAO(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    @Override
    public List<Migration> findAll() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        this.collection.find().forEach(d -> migrations.add(new Migration(d.getString((Object)"version"), d.getString((Object)"description"), d.getString((Object)"author"), Optional.ofNullable(d.getDate((Object)"started")).map(DateTime::new).orElse(null), Optional.ofNullable(d.getDate((Object)"finished")).map(DateTime::new).orElse(null), MigrationStatus.valueOf(d.getString((Object)"status")), d.getString((Object)"failureMessage"))));
        return migrations;
    }

    @Override
    public void save(Migration migration) {
        Document d = new Document("version", (Object)migration.getVersion()).append("description", (Object)migration.getDescription()).append("author", (Object)migration.getAuthor()).append("started", Optional.ofNullable(migration.getStarted()).map(AbstractInstant::toDate).orElse(null)).append("finished", Optional.ofNullable(migration.getFinished()).map(AbstractInstant::toDate).orElse(null)).append("status", (Object)migration.getStatus().name()).append("failureMessage", (Object)migration.getFailureMessage());
        this.collection.replaceOne(Filters.eq((String)"version", (Object)migration.getVersion()), (Object)d, new UpdateOptions().upsert(true));
    }

    @Override
    public Optional<Migration> findLastSuccessful() {
        return this.findAll().stream().filter(m -> m.getStatus() == MigrationStatus.Successful).sorted((m1, m2) -> m1.getVersion().compareTo(m2.getVersion())).reduce((p, c) -> c);
    }
}

