/*
 * Decompiled with CFR 0.152.
 */
package net.overburn.redfort.keygen;

import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import net.overburn.redfort.exceptions.KeyDerivationException;
import net.overburn.redfort.keygen.SymmetricKeyGenerator;
import net.overburn.redfort.util.Toolbox;

public class ChaCha20KeyGenerator
implements SymmetricKeyGenerator {
    private static final String KEY_DERIVATION_FUNCTION = "ChaCha20";

    @Override
    public SecretKeySpec generate() {
        return this.wrap(this.derive(256));
    }

    @Override
    public byte[] derive(int keyLen) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_DERIVATION_FUNCTION);
            keyGenerator.init(keyLen, Toolbox.getRandomBitGenerator());
            return keyGenerator.generateKey().getEncoded();
        }
        catch (InvalidParameterException | NoSuchAlgorithmException e) {
            throw new KeyDerivationException(e.getMessage());
        }
    }

    public SecretKeySpec wrap(byte[] rawKey) {
        return this.wrap(rawKey, KEY_DERIVATION_FUNCTION);
    }

    public SecretKeySpec wrap(String rawKey) {
        return this.wrap(Toolbox.decode(rawKey));
    }
}

