/*
 * Decompiled with CFR 0.152.
 */
package net.overburn.redfort.keygen;

import java.nio.charset.StandardCharsets;
import javax.crypto.spec.SecretKeySpec;
import net.overburn.redfort.keygen.SecretBasedKeyGenerator;
import net.overburn.redfort.util.Toolbox;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public class Argon2KeyGenerator
implements SecretBasedKeyGenerator {
    private static final String KEY_DERIVATION_FUNCTION = "Argon2id";
    private static final int KEY_LENGTH = 256;
    private static final int ITERATIONS = 3;

    @Override
    public SecretKeySpec generate(String secret, String salt) {
        return this.generate(secret, salt, null);
    }

    @Override
    public SecretKeySpec generate(String secret, String salt, String pepper) {
        return this.generate(secret, salt, pepper, null);
    }

    @Override
    public SecretKeySpec generate(String secret, String salt, String pepper, byte[] ad) {
        return this.generate(secret.toCharArray(), salt == null ? null : salt.getBytes(StandardCharsets.UTF_8), pepper == null ? null : pepper.getBytes(StandardCharsets.UTF_8), ad);
    }

    @Override
    public SecretKeySpec generate(char[] secret, byte[] salt, byte[] pepper, byte[] ad) {
        return this.wrap(this.derive(secret, salt, pepper, ad));
    }

    @Override
    public byte[] derive(char[] secret, byte[] salt, byte[] pepper, byte[] additional) {
        Argon2BytesGenerator bytesGenerator = this.builder(salt, pepper, additional);
        byte[] rawKey = new byte[32];
        bytesGenerator.generateBytes(secret, rawKey);
        return rawKey;
    }

    private Argon2BytesGenerator builder(byte[] salt, byte[] pepper, byte[] ad) {
        Argon2BytesGenerator bytesGenerator = new Argon2BytesGenerator();
        Argon2Parameters.Builder builder = new Argon2Parameters.Builder(2).withVersion(19).withIterations(3).withMemoryAsKB(32).withParallelism(4).withSalt(salt);
        if (pepper != null) {
            builder.withSecret(pepper);
        }
        if (ad != null) {
            builder.withAdditional(ad);
        }
        bytesGenerator.init(builder.build());
        return bytesGenerator;
    }

    public SecretKeySpec wrap(byte[] rawKey) {
        return this.wrap(rawKey, KEY_DERIVATION_FUNCTION);
    }

    public SecretKeySpec wrap(String rawKey) {
        return this.wrap(Toolbox.decode(rawKey));
    }
}

