/*
 * Decompiled with CFR 0.152.
 */
package net.overburn.redfort.keygen;

import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import net.overburn.redfort.exceptions.KeyDerivationException;
import net.overburn.redfort.keygen.SymmetricKeyGenerator;
import net.overburn.redfort.util.Toolbox;

public class AESKeyGenerator
implements SymmetricKeyGenerator {
    private static final String KEY_DERIVATION_FUNCTION = "AES";

    @Override
    public SecretKeySpec generate() {
        return this.generate(256);
    }

    public SecretKeySpec generate(int keyLen) {
        return this.wrap(this.derive(keyLen));
    }

    @Override
    public byte[] derive(int keyLen) {
        try {
            keyLen = keyLen == 128 || keyLen == 192 || keyLen == 256 ? keyLen : 256;
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_DERIVATION_FUNCTION);
            keyGenerator.init(keyLen, Toolbox.getRandomBitGenerator());
            return keyGenerator.generateKey().getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyDerivationException(e.getMessage());
        }
    }

    public SecretKeySpec wrap(byte[] rawKey) {
        return this.wrap(rawKey, KEY_DERIVATION_FUNCTION);
    }

    public SecretKeySpec wrap(String rawKey) {
        return this.wrap(Toolbox.decode(rawKey));
    }
}

