/*
 * Decompiled with CFR 0.152.
 */
package net.overburn.redfort.devices;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import net.overburn.redfort.exceptions.DecryptionException;
import net.overburn.redfort.exceptions.EncryptionException;
import net.overburn.redfort.util.Toolbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scrambler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Scrambler.class);
    public static final String CHACHA20_POLY1305 = "ChaCha20-Poly1305/None/NoPadding";
    public static final String AES_GCM_256 = "AES/GCM/NoPadding";
    public static final int IV_LENGTH = 96;
    public static final String CIPHER_TEXT_DELIMITER = ".";
    public static final String CIPHER_TEXT_DELIMITER_REGEX = "\\.";
    private final String cipherSuite;

    public Scrambler(String cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public Scrambler() {
        this(CHACHA20_POLY1305);
    }

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public String encrypt(byte[] clearBytes, SecretKeySpec key) {
        return this.encrypt(clearBytes, key, null);
    }

    public String encrypt(byte[] clearBytes, SecretKeySpec key, byte[] iv) {
        boolean ivNotSupplied = iv == null;
        try {
            Cipher encryptor = Cipher.getInstance(this.cipherSuite);
            if (ivNotSupplied) {
                iv = new byte[12];
                Toolbox.getRandomBitGenerator().nextBytes(iv);
            }
            AlgorithmParameterSpec ivParameterSpec = AES_GCM_256.equalsIgnoreCase(this.cipherSuite) ? new GCMParameterSpec(96, iv) : new IvParameterSpec(iv);
            key = AES_GCM_256.equalsIgnoreCase(this.cipherSuite) ? new SecretKeySpec(key.getEncoded(), "AES") : key;
            encryptor.init(1, (Key)key, ivParameterSpec, Toolbox.getRandomBitGenerator());
            byte[] cipherBytes = encryptor.doFinal(clearBytes);
            return Toolbox.encode(cipherBytes) + CIPHER_TEXT_DELIMITER + Toolbox.encode(iv);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptionException(e.getMessage());
        }
    }

    public byte[] decrypt(String cipherText, SecretKeySpec key) {
        if (cipherText.contains(CIPHER_TEXT_DELIMITER)) {
            String[] cipherBlocks = cipherText.split(CIPHER_TEXT_DELIMITER_REGEX);
            return this.decrypt(cipherBlocks[0], key, cipherBlocks[1]);
        }
        throw new DecryptionException("IV not available. IV is not supplied with or padded onto cipher text.");
    }

    public byte[] decrypt(String cipherText, SecretKeySpec key, String iv) {
        return this.decrypt(Toolbox.decode(cipherText), key, Toolbox.decode(iv));
    }

    private byte[] decrypt(byte[] cipherBytes, SecretKeySpec key, byte[] iv) {
        byte[] clearBytes;
        try {
            Cipher decryptor = Cipher.getInstance(this.cipherSuite);
            AlgorithmParameterSpec ivParameterSpec = AES_GCM_256.equalsIgnoreCase(this.cipherSuite) ? new GCMParameterSpec(96, iv) : new IvParameterSpec(iv);
            key = AES_GCM_256.equalsIgnoreCase(this.cipherSuite) ? new SecretKeySpec(key.getEncoded(), "AES") : key;
            decryptor.init(2, (Key)key, ivParameterSpec, Toolbox.getRandomBitGenerator());
            clearBytes = decryptor.doFinal(cipherBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new DecryptionException(e.getMessage());
        }
        return clearBytes;
    }
}

