/*
 * Decompiled with CFR 0.152.
 */
package net.overburn.redfort.devices;

import java.nio.charset.StandardCharsets;
import javax.crypto.spec.SecretKeySpec;
import net.overburn.redfort.devices.Scrambler;
import net.overburn.redfort.exceptions.CryptoDeviceException;
import net.overburn.redfort.keygen.AESKeyGenerator;
import net.overburn.redfort.keygen.Argon2KeyGenerator;
import net.overburn.redfort.keygen.BasicKeyGenerator;
import net.overburn.redfort.keygen.ChaCha20KeyGenerator;
import net.overburn.redfort.keygen.PBKDF2KeyGenerator;
import net.overburn.redfort.keygen.SecretBasedKeyGenerator;

public class CryptoDriver {
    private final Scrambler scrambler;
    private final BasicKeyGenerator keyGenerator;

    public CryptoDriver(String cipherSuite, String kdf) {
        this(CryptoDriver.newScrambler(cipherSuite), CryptoDriver.newKeyGenerator(kdf));
    }

    public CryptoDriver(Scrambler scrambler, BasicKeyGenerator keyGenerator) {
        this.scrambler = scrambler;
        this.keyGenerator = keyGenerator;
    }

    public Scrambler getScrambler() {
        return this.scrambler;
    }

    public BasicKeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    private static Scrambler newScrambler(String cipherSuite) {
        if ("ChaCha20-Poly1305/None/NoPadding".equalsIgnoreCase(cipherSuite) || "AES/GCM/NoPadding".equalsIgnoreCase(cipherSuite)) {
            return new Scrambler(cipherSuite);
        }
        throw new CryptoDeviceException("Unsupported choice of Cipher Suite. Use ChaCha20-Poly1305/None/NoPadding for good security margin");
    }

    private static BasicKeyGenerator newKeyGenerator(String kdf) {
        switch (kdf) {
            case "Argon2id": {
                return new Argon2KeyGenerator();
            }
            case "PBKDF2WithHmacSHA512": {
                return new PBKDF2KeyGenerator();
            }
            case "AES": {
                return new AESKeyGenerator();
            }
            case "ChaCha20": {
                return new ChaCha20KeyGenerator();
            }
        }
        throw new CryptoDeviceException("Unsupported choice of KDF. Use Argon2id for good security margin");
    }

    public static CryptoDriver newDriver(String cipherSuite, String kdf) {
        return new CryptoDriver(cipherSuite, kdf);
    }

    public static CryptoDriver newSymKeyDriver() {
        return CryptoDriver.newDriver("ChaCha20-Poly1305/None/NoPadding", "ChaCha20");
    }

    public static CryptoDriver newSecretDriver() {
        return CryptoDriver.newDriver("ChaCha20-Poly1305/None/NoPadding", "Argon2id");
    }

    public String encrypt(String clearText, SecretKeySpec key) {
        return this.encrypt(clearText.getBytes(StandardCharsets.UTF_8), key);
    }

    public String encrypt(byte[] clearBytes, SecretKeySpec key) {
        return this.scrambler.encrypt(clearBytes, key);
    }

    public byte[] decrypt(String cipherText, SecretKeySpec key) {
        return this.scrambler.decrypt(cipherText, key);
    }

    public String encrypt(byte[] clearBytes, String secret, String salt) {
        SecretBasedKeyGenerator keyGenerator = (SecretBasedKeyGenerator)this.keyGenerator;
        return this.encrypt(clearBytes, keyGenerator.generate(secret, salt));
    }

    public byte[] decrypt(String cipherText, String secret, String salt) {
        SecretBasedKeyGenerator keyGenerator = (SecretBasedKeyGenerator)this.keyGenerator;
        return this.decrypt(cipherText, keyGenerator.generate(secret, salt));
    }

    public String encrypt(byte[] clearBytes, String secret) {
        return this.encrypt(clearBytes, secret, "");
    }

    public byte[] decrypt(String cipherText, String secret) {
        return this.decrypt(cipherText, secret, "");
    }
}

