/*
 * Decompiled with CFR 0.152.
 */
package net.overburn.redfort.util;

import java.nio.charset.StandardCharsets;
import java.security.DrbgParameters;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import net.overburn.redfort.exceptions.CryptoDeviceException;

public class Toolbox {
    private static final String SOME_HARDCODED_STRING = "scoop-unbounded-riding-unwilling-existing-maverick-cuddly-foil-cvk-repulsion-hardness-humpback";
    public static final String CIPHER_TEXT_DELIMITER = ".";

    private Toolbox() {
        throw new IllegalStateException("Util class. Do not instantiate.");
    }

    public static String encode(byte[] raw) {
        return Base64.getEncoder().encodeToString(raw);
    }

    public static byte[] decode(String raw) {
        return Base64.getDecoder().decode(raw);
    }

    public static String encodeCipherText(byte[] cipherBytes, byte[] ivBytes) {
        return Toolbox.encode(cipherBytes) + CIPHER_TEXT_DELIMITER + Toolbox.encode(ivBytes);
    }

    public static byte[] decodeCipherText(String raw) {
        return raw.getBytes(StandardCharsets.UTF_8);
    }

    public static SecureRandom getRandomBitGenerator() {
        try {
            return SecureRandom.getInstance("DRBG", DrbgParameters.instantiation(256, DrbgParameters.Capability.PR_AND_RESEED, SOME_HARDCODED_STRING.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoDeviceException(e.getMessage());
        }
    }
}

