/*
 * Decompiled with CFR 0.152.
 */
package net.overburn.redfort.keygen;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.overburn.redfort.exceptions.KeyDerivationException;
import net.overburn.redfort.keygen.SecretBasedKeyGenerator;
import net.overburn.redfort.util.Toolbox;

public class PBKDF2KeyGenerator
implements SecretBasedKeyGenerator {
    private static final String KEY_DERIVATION_FUNCTION = "PBKDF2WithHmacSHA512";
    private static final int KEY_LENGTH = 256;
    private static final int ITERATIONS = 3;

    @Override
    public SecretKeySpec generate(String secret, String salt) {
        return this.generate(secret, salt, null);
    }

    @Override
    public SecretKeySpec generate(String secret, String salt, String pepper) {
        return this.generate(secret, salt, pepper, null);
    }

    @Override
    public SecretKeySpec generate(String secret, String salt, String pepper, byte[] ad) {
        return this.generate(secret.toCharArray(), salt == null ? null : salt.getBytes(StandardCharsets.UTF_8), pepper == null ? null : pepper.getBytes(StandardCharsets.UTF_8), ad);
    }

    @Override
    public SecretKeySpec generate(char[] secret, byte[] salt, byte[] pepper, byte[] ad) {
        return this.wrap(this.derive(secret, salt, pepper, ad));
    }

    @Override
    public byte[] derive(char[] secret, byte[] salt, byte[] pepper, byte[] additional) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(secret, salt, 3, 256);
            SecretKeyFactory pbkdfKeyFactory = SecretKeyFactory.getInstance(KEY_DERIVATION_FUNCTION);
            SecretKey rawKey = pbkdfKeyFactory.generateSecret(keySpec);
            return rawKey.getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new KeyDerivationException(e.getMessage());
        }
    }

    public SecretKeySpec wrap(byte[] rawKey) {
        return this.wrap(rawKey, KEY_DERIVATION_FUNCTION);
    }

    public SecretKeySpec wrap(String rawKey) {
        return this.wrap(Toolbox.decode(rawKey));
    }
}

