/*
 * Decompiled with CFR 0.152.
 */
package net.overburn.redfort.keygen;

import javax.crypto.spec.SecretKeySpec;
import net.overburn.redfort.util.Toolbox;

public interface BasicKeyGenerator {
    public static final String ARGON2 = "Argon2id";
    public static final String PBKDF2_WITH_HMAC_SHA_512 = "PBKDF2WithHmacSHA512";
    public static final String AES = "AES";
    public static final String CHACHA20 = "ChaCha20";
    public static final int DEFAULT_KEY_LENGTH = 256;

    default public SecretKeySpec wrap(byte[] rawKey, String keyDeriveFn) {
        return new SecretKeySpec(rawKey, keyDeriveFn);
    }

    default public SecretKeySpec wrap(String rawKey, String keyDeriveFn) {
        return this.wrap(Toolbox.decode(rawKey), keyDeriveFn);
    }
}

