package net.overburn.redfort.keygen;

import javax.crypto.spec.SecretKeySpec;

/**
 * Derives a suitable key from a secret/password, salt, extra secret for keyed hashing. Additional info can be used to tag.
 * WARNING: Stick to {@link Argon2KeyGenerator} and avoid modifying/implementing this or any implementations without understanding the ramifications.
 * For more info:
 * @see <a href="https://datatracker.ietf.org/doc/html/rfc9106">Argon 2id</a>
 * @see <a href="https://nvlpubs.nist.gov/nistpubs/Legacy/SP/nistspecialpublication800-132.pdf">PBKDF2WithHmacSHA512</a>
 */
public interface SecretBasedKeyGenerator extends BasicKeyGenerator{


    SecretKeySpec generate(String secret, String salt);

    SecretKeySpec generate(String secret, String salt, String pepper);

    SecretKeySpec generate(String secret, String salt, String pepper, byte[] ad);

    SecretKeySpec generate(char[] secret, byte[] salt, byte[] pepper, byte[] ad);

    /**
     * Derives a suitable key from a secret/password, salt, extra secret for keyed hashing. Additional info can be used to tag.
     *
     * @param secret secret or password that is supplied by user or server. Take utmost care.
     * @param salt Unique value for each secret that's known only to server for each secret
     * @param pepper Unique value for each secret that's known only to server
     * @param additional Any additional Tag for ID or classification
     * @return key that can be wrapped and supplied to Scrambler
     */
    byte[] derive(char[] secret, byte[] salt, byte[] pepper, byte[] additional);


}
