/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.therock.service;

import jakarta.ws.rs.HeaderParam;
import java.math.BigInteger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

public class TheRockDigest
implements ParamsDigest {
    public static final String HMAC_SHA_512 = "HmacSHA512";
    private final Mac mac;

    public TheRockDigest(String secretKeyStr) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyStr.getBytes(), HMAC_SHA_512);
            this.mac = Mac.getInstance(HMAC_SHA_512);
            this.mac.init(secretKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing The Rock Signer", e);
        }
    }

    public String digestParams(RestInvocation restInvocation) {
        String nonce = restInvocation.getParamValue(HeaderParam.class, "X-TRT-NONCE").toString();
        this.mac.update(nonce.getBytes());
        this.mac.update(restInvocation.getInvocationUrl().getBytes());
        return String.format("%0128x", new BigInteger(1, this.mac.doFinal()));
    }
}

