/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.therock.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;
import org.knowm.xchange.therock.TheRockAdapters;
import org.knowm.xchange.therock.dto.account.TheRockWithdrawalResponse;
import org.knowm.xchange.therock.dto.trade.TheRockTransaction;
import org.knowm.xchange.therock.dto.trade.TheRockTransactions;
import org.knowm.xchange.therock.service.TheRockAccountServiceRaw;
import org.knowm.xchange.therock.service.TheRockFundingHistoryParams;

public class TheRockAccountService
extends TheRockAccountServiceRaw
implements AccountService {
    public TheRockAccountService(Exchange exchange) {
        super(exchange);
    }

    private static FundingRecord adapt(TheRockTransaction txn, FundingRecord.Type type) {
        TheRockTransaction.TransferDetail transferDetail = txn.getTransferDetail();
        String transferDetailId = null;
        String address = null;
        if (transferDetail != null) {
            transferDetailId = transferDetail.getId();
            address = transferDetail.getRecipient();
        }
        return new FundingRecord(address, txn.getDate(), Currency.getInstance((String)txn.getCurrency()), txn.getPrice(), String.valueOf(txn.getId()), transferDetailId, type, FundingRecord.Status.COMPLETE, null, null, null);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return TheRockAdapters.adaptAccountInfo(this.balances(), this.exchange.getExchangeSpecification().getUserName());
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        TheRockWithdrawalResponse response = this.withdrawDefault(currency, amount, address);
        return String.format("%d", response.getTransactionId());
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress());
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... arguments) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new TheRockFundingHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        TheRockTransactions txns;
        int page;
        Currency currency = null;
        Date after = null;
        Date before = null;
        FundingRecord.Type type = null;
        if (params instanceof TradeHistoryParamCurrency) {
            TradeHistoryParamCurrency tradeHistoryParamCurrency = (TradeHistoryParamCurrency)params;
            currency = tradeHistoryParamCurrency.getCurrency();
        }
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan tradeHistoryParamsTimeSpan = (TradeHistoryParamsTimeSpan)params;
            after = tradeHistoryParamsTimeSpan.getStartTime();
            before = tradeHistoryParamsTimeSpan.getEndTime();
        }
        if (params instanceof HistoryParamsFundingType) {
            HistoryParamsFundingType historyParamsFundingType = (HistoryParamsFundingType)params;
            type = historyParamsFundingType.getType();
        }
        ArrayList<FundingRecord> all = new ArrayList<FundingRecord>();
        if (type == null || type == FundingRecord.Type.DEPOSIT) {
            page = 1;
            while ((txns = this.deposits(currency, after, before, page++)).getTransactions().length != 0) {
                for (TheRockTransaction txn : txns.getTransactions()) {
                    all.add(TheRockAccountService.adapt(txn, FundingRecord.Type.DEPOSIT));
                }
            }
        }
        if (type == null || type == FundingRecord.Type.WITHDRAWAL) {
            page = 1;
            while ((txns = this.withdrawls(currency, after, before, page++)).getTransactions().length != 0) {
                for (TheRockTransaction txn : txns.getTransactions()) {
                    all.add(TheRockAccountService.adapt(txn, FundingRecord.Type.WITHDRAWAL));
                }
            }
        }
        return all;
    }
}

