/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.therock;

import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.therock.service.TheRockAccountService;
import org.knowm.xchange.therock.service.TheRockMarketDataService;
import org.knowm.xchange.therock.service.TheRockTradeService;
import org.knowm.xchange.utils.nonce.TimestampIncrementingNonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class TheRockExchange
extends BaseExchange
implements Exchange {
    public static final String CURRENCY_PAIR = "CURRENCY_PAIR";
    private SynchronizedValueFactory<Long> nonceFactory = new TimestampIncrementingNonceFactory();

    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
    }

    protected void initServices() {
        this.marketDataService = new TheRockMarketDataService(this);
        if (this.exchangeSpecification.getApiKey() != null && this.exchangeSpecification.getSecretKey() != null) {
            this.tradeService = new TheRockTradeService(this);
            this.accountService = new TheRockAccountService(this);
        }
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://api.therocktrading.com");
        exchangeSpecification.setHost("api.therocktrading.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("The Rock Trading");
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }
}

