/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.mexc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.mexc.dto.account.MEXCBalance;
import org.knowm.xchange.mexc.dto.trade.MEXCOrder;
import org.knowm.xchange.mexc.dto.trade.MEXCOrderRequestPayload;

public class MEXCAdapters {
    public static Wallet adaptMEXCBalances(Map<String, MEXCBalance> mexcBalances) {
        ArrayList<Balance> balances = new ArrayList<Balance>(mexcBalances.size());
        for (Map.Entry<String, MEXCBalance> mexcBalance : mexcBalances.entrySet()) {
            MEXCBalance mexcBalanceValue = mexcBalance.getValue();
            BigDecimal available = new BigDecimal(mexcBalanceValue.getAvailable());
            BigDecimal frozen = new BigDecimal(mexcBalanceValue.getFrozen());
            balances.add(new Balance(new Currency(mexcBalance.getKey()), frozen.add(available), available));
        }
        return Wallet.Builder.from(balances).build();
    }

    public static String convertToMEXCSymbol(String instrumentName) {
        return instrumentName.replace("/", "_").toUpperCase();
    }

    private static Instrument adaptSymbol(String symbol) {
        String[] symbolTokenized = symbol.split("_");
        return new CurrencyPair(symbolTokenized[0], symbolTokenized[1]);
    }

    public static MEXCOrderRequestPayload adaptOrder(LimitOrder limitOrder) {
        return new MEXCOrderRequestPayload(MEXCAdapters.convertToMEXCSymbol(limitOrder.getInstrument().toString()), limitOrder.getLimitPrice().toString(), limitOrder.getOriginalAmount().toString(), limitOrder.getType().toString(), "LIMIT_ORDER", null);
    }

    public static Order adaptOrder(MEXCOrder mexcOrder) {
        BigDecimal dealQuantity = new BigDecimal(mexcOrder.getDealQuantity());
        LimitOrder limitOrder = new LimitOrder(Order.OrderType.valueOf((String)mexcOrder.getType()), new BigDecimal(mexcOrder.getQuantity()), dealQuantity, MEXCAdapters.adaptSymbol(mexcOrder.getSymbol()), mexcOrder.getId(), new Date(mexcOrder.getCreateTime()), new BigDecimal(mexcOrder.getPrice())){};
        BigDecimal dealAmount = new BigDecimal(mexcOrder.getDealAmount());
        BigDecimal averagePrice = MEXCAdapters.getAveragePrice(dealQuantity, dealAmount);
        limitOrder.setAveragePrice(averagePrice);
        limitOrder.setOrderStatus(Order.OrderStatus.valueOf((String)mexcOrder.getState()));
        return limitOrder;
    }

    private static BigDecimal getAveragePrice(BigDecimal dealQuantity, BigDecimal dealAmount) {
        if (dealQuantity.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return dealAmount.divide(dealQuantity, RoundingMode.HALF_EVEN);
    }
}

