/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.mexc.service;

import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.mexc.MEXCAdapters;
import org.knowm.xchange.mexc.dto.MEXCResult;
import org.knowm.xchange.mexc.dto.account.MEXCBalance;
import org.knowm.xchange.mexc.service.MEXCAccountServiceRaw;
import org.knowm.xchange.mexc.service.MEXCException;
import org.knowm.xchange.service.account.AccountService;

public class MEXCAccountService
extends MEXCAccountServiceRaw
implements AccountService {
    public MEXCAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        try {
            MEXCResult<Map<String, MEXCBalance>> walletBalances = this.getWalletBalances();
            Map<String, MEXCBalance> walletBalancesResult = walletBalances.getData();
            return new AccountInfo(new Wallet[]{MEXCAdapters.adaptMEXCBalances(walletBalancesResult)});
        }
        catch (MEXCException e) {
            throw new ExchangeException((Throwable)((Object)e));
        }
    }
}

