/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrder;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOwnTrade;
import org.knowm.xchange.hitbtc.v2.service.HitbtcTradeHistoryParams;
import org.knowm.xchange.hitbtc.v2.service.HitbtcTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByUserReferenceParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;

public class HitbtcTradeService
extends HitbtcTradeServiceRaw
implements TradeService {
    public HitbtcTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        List<HitbtcOrder> openOrdersRaw = this.getOpenOrdersRaw();
        return HitbtcAdapters.adaptOpenOrders(openOrdersRaw);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        return this.placeMarketOrderRaw((MarketOrder)marketOrder).id;
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return this.placeLimitOrderRaw((LimitOrder)limitOrder).id;
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByUserReferenceParams) {
            String clientOrderId = ((CancelOrderByUserReferenceParams)orderParams).getUserReference();
            HitbtcOrder cancelOrderRaw = this.cancelOrderRaw(clientOrderId);
            return "canceled".equals(cancelOrderRaw.status);
        }
        throw new ExchangeException("Need userReference for cancelling orders. Use CancelOrderByUserReferenceParams.");
    }

    public Class[] getRequiredCancelOrderParamClasses() {
        return new Class[]{CancelOrderByUserReferenceParams.class};
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        Integer limit = 1000;
        long offset = 0L;
        if (params instanceof TradeHistoryParamLimit) {
            limit = ((TradeHistoryParamLimit)params).getLimit();
        }
        if (params instanceof TradeHistoryParamOffset) {
            TradeHistoryParamOffset tradeHistoryParamOffset = (TradeHistoryParamOffset)params;
            offset = tradeHistoryParamOffset.getOffset();
        }
        String symbol = null;
        if (params instanceof TradeHistoryParamCurrencyPair) {
            CurrencyPair pair = ((TradeHistoryParamCurrencyPair)params).getCurrencyPair();
            symbol = HitbtcAdapters.adaptCurrencyPair(pair);
        }
        List<HitbtcOwnTrade> tradeHistoryRaw = this.getTradeHistoryRaw(symbol, limit, offset);
        return HitbtcAdapters.adaptTradeHistory(tradeHistoryRaw);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new HitbtcTradeHistoryParams(null, 100, 0L);
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Class getRequiredOrderQueryParamClass() {
        return OrderQueryParamCurrencyPair.class;
    }

    public Collection<Order> getOrder(OrderQueryParams ... orderQueryParams) throws IOException {
        if (orderQueryParams == null) {
            return new ArrayList<Order>();
        }
        ArrayList<Order> orders = new ArrayList<Order>();
        for (OrderQueryParams param : orderQueryParams) {
            if (!(param instanceof OrderQueryParamCurrencyPair)) {
                throw new ExchangeException("Parameters must be an instance of OrderQueryParamCurrencyPair");
            }
            HitbtcOrder rawOrder = this.getHitbtcOrder(HitbtcAdapters.adaptCurrencyPair(((OrderQueryParamCurrencyPair)param).getCurrencyPair()), param.getOrderId());
            if (rawOrder == null) continue;
            orders.add((Order)HitbtcAdapters.adaptOrder(rawOrder));
        }
        return orders;
    }
}

