/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTransaction;
import org.knowm.xchange.hitbtc.v2.service.HitbtcAccountServiceRaw;
import org.knowm.xchange.hitbtc.v2.service.HitbtcFundingHistoryParams;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.MoneroWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.RippleWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class HitbtcAccountService
extends HitbtcAccountServiceRaw
implements AccountService {
    public HitbtcAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(new Wallet[]{HitbtcAdapters.adaptWallet("Trading", this.getTradingBalance())});
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdrawFunds((WithdrawFundsParams)new DefaultWithdrawFundsParams(address, currency, amount));
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof MoneroWithdrawFundsParams) {
            MoneroWithdrawFundsParams moneroWithdrawFundsParams = (MoneroWithdrawFundsParams)params;
            return this.withdrawFundsRaw(moneroWithdrawFundsParams.getCurrency(), moneroWithdrawFundsParams.getAmount(), moneroWithdrawFundsParams.getAddress(), moneroWithdrawFundsParams.getPaymentId());
        }
        if (params instanceof RippleWithdrawFundsParams) {
            RippleWithdrawFundsParams rippleWithdrawFundsParams = (RippleWithdrawFundsParams)params;
            return this.withdrawFundsRaw(rippleWithdrawFundsParams.getCurrency(), rippleWithdrawFundsParams.getAmount(), rippleWithdrawFundsParams.getAddress(), rippleWithdrawFundsParams.getTag());
        }
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFundsRaw(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress(), null);
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        return this.getDepositAddress(currency).getAddress();
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new HitbtcFundingHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        String currencyCode = null;
        Integer limit = 1000;
        Integer offset = 0;
        if (params instanceof TradeHistoryParamCurrency) {
            Currency currency = ((TradeHistoryParamCurrency)params).getCurrency();
            String string = currencyCode = currency != null ? currency.getCurrencyCode() : null;
        }
        if (params instanceof TradeHistoryParamLimit) {
            limit = ((TradeHistoryParamLimit)params).getLimit();
        }
        if (params instanceof TradeHistoryParamOffset) {
            offset = ((TradeHistoryParamOffset)params).getOffset().intValue();
        }
        List<HitbtcTransaction> transactions = this.getTransactions(currencyCode, limit, offset);
        ArrayList<FundingRecord> records = new ArrayList<FundingRecord>();
        for (HitbtcTransaction transaction : transactions) {
            records.add(HitbtcAdapters.adapt(transaction));
        }
        return records;
    }
}

