/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.hitbtc.v2.Hitbtc;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcAddress;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcBalance;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcException;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcInternalTransferResponse;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrder;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOwnTrade;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTransaction;
import org.knowm.xchange.hitbtc.v2.service.HitbtcOrderType;
import org.knowm.xchange.hitbtc.v2.service.HitbtcTimeInForce;
import si.mazi.rescu.HttpStatusIOException;

@Path(value="/api/2/")
public interface HitbtcAuthenticated
extends Hitbtc {
    @GET
    @Path(value="account/balance")
    public List<HitbtcBalance> getMainBalance() throws IOException, HitbtcException;

    @GET
    @Path(value="account/crypto/address/{currency}")
    public HitbtcAddress getHitbtcDepositAddress(@PathParam(value="currency") String var1) throws IOException, HitbtcException;

    @GET
    @Path(value="account/transactions")
    public List<HitbtcTransaction> transactions(@QueryParam(value="currency") String var1, @QueryParam(value="sort") String var2, @QueryParam(value="by") String var3, @QueryParam(value="from") String var4, @QueryParam(value="till") String var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="offset") Integer var7) throws HitbtcException, HttpStatusIOException;

    @POST
    @Path(value="account/transfer")
    public HitbtcInternalTransferResponse transferToTrading(@FormParam(value="amount") BigDecimal var1, @FormParam(value="currency") String var2, @FormParam(value="type") String var3) throws IOException, HitbtcException;

    @POST
    @Path(value="account/crypto/withdraw")
    public Map payout(@FormParam(value="amount") BigDecimal var1, @FormParam(value="currency") String var2, @FormParam(value="address") String var3, @FormParam(value="paymentId") String var4, @FormParam(value="includeFee") Boolean var5) throws HitbtcException, HttpStatusIOException;

    @GET
    @Path(value="order")
    public List<HitbtcOrder> getHitbtcActiveOrders() throws IOException, HitbtcException;

    @POST
    @Path(value="order")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public HitbtcOrder postHitbtcNewOrder(@FormParam(value="clientOrderId") String var1, @FormParam(value="symbol") String var2, @FormParam(value="side") String var3, @FormParam(value="price") BigDecimal var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="type") HitbtcOrderType var6, @FormParam(value="timeInForce") HitbtcTimeInForce var7) throws IOException, HitbtcException;

    @PATCH
    @Path(value="order/{clientOrderId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public HitbtcOrder updateHitbtcOrder(@PathParam(value="clientOrderId") String var1, @FormParam(value="quantity") BigDecimal var2, @FormParam(value="requestClientId") String var3, @FormParam(value="price") BigDecimal var4) throws IOException, HitbtcException;

    @DELETE
    @Path(value="order")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public List<HitbtcOrder> cancelAllOrders(@FormParam(value="symbol") String var1) throws IOException, HitbtcException;

    @DELETE
    @Path(value="order/{clientOrderId}")
    public HitbtcOrder cancelSingleOrder(@PathParam(value="clientOrderId") String var1) throws IOException, HitbtcException;

    @GET
    @Path(value="trading/balance")
    public List<HitbtcBalance> getTradingBalance() throws IOException, HitbtcException;

    @GET
    @Path(value="history/trades")
    public List<HitbtcOwnTrade> getHitbtcTrades(@QueryParam(value="symbol") String var1, @QueryParam(value="sort") String var2, @QueryParam(value="by") String var3, @QueryParam(value="from") String var4, @QueryParam(value="till") String var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="offset") long var7) throws IOException, HitbtcException;

    @GET
    @Path(value="history/order")
    public List<HitbtcOrder> getHitbtcRecentOrders() throws IOException, HitbtcException;

    @GET
    @Path(value="history/order")
    public List<HitbtcOrder> getHitbtcOrder(@QueryParam(value="symbol") String var1, @QueryParam(value="clientOrderId") String var2) throws IOException, HitbtcException;

    @GET
    @Path(value="/history/order/{id}/trades")
    public List<HitbtcOwnTrade> getHistorialTradesByOrder(@PathParam(value="id") String var1) throws IOException, HitbtcException;
}

