/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcCandle;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcCurrency;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrderBook;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcSymbol;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTicker;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTrade;

@Path(value="/api/2/")
public interface Hitbtc {
    @GET
    @Path(value="public/symbol")
    public List<HitbtcSymbol> getSymbols() throws IOException;

    @GET
    @Path(value="public/currency")
    public List<HitbtcCurrency> getCurrencies() throws IOException;

    @GET
    @Path(value="public/currency/{currency}")
    public HitbtcCurrency getCurrency(@PathParam(value="currency") String var1) throws IOException;

    @GET
    @Path(value="public/ticker")
    public List<HitbtcTicker> getTickers() throws IOException;

    @GET
    @Path(value="public/ticker/{symbol}")
    public HitbtcTicker getTicker(@PathParam(value="symbol") String var1) throws IOException;

    @GET
    @Path(value="public/orderbook/{symbol}")
    public HitbtcOrderBook getOrderBook(@PathParam(value="symbol") String var1, @QueryParam(value="limit") Integer var2) throws IOException;

    @GET
    @Path(value="public/trades/{symbol}")
    public List<HitbtcTrade> getTrades(@PathParam(value="symbol") String var1, @QueryParam(value="limit") long var2, @QueryParam(value="offset") long var4) throws IOException;

    @GET
    @Path(value="public/trades/{symbol}")
    public List<HitbtcTrade> getTrades(@PathParam(value="symbol") String var1, @QueryParam(value="sort") String var2, @QueryParam(value="by") String var3, @QueryParam(value="from") String var4, @QueryParam(value="limit") long var5) throws IOException;

    @GET
    @Path(value="public/ticker")
    public List<HitbtcTicker> getHitbtcTickers() throws IOException;

    @GET
    @Path(value="public/candles/{symbol}")
    public List<HitbtcCandle> getHitbtcOHLC(@PathParam(value="symbol") String var1, @QueryParam(value="limit") int var2, @QueryParam(value="period") String var3) throws IOException;

    @GET
    @Path(value="public/candles/{symbol}")
    public List<HitbtcCandle> getHitbtcOHLC(@PathParam(value="symbol") String var1, @QueryParam(value="limit") int var2, @QueryParam(value="period") String var3, @QueryParam(value="sort") String var4) throws IOException;

    @GET
    @Path(value="public/candles/{symbol}")
    public List<HitbtcCandle> getHitbtcOHLC(@PathParam(value="symbol") String var1, @QueryParam(value="limit") int var2, @QueryParam(value="period") String var3, @QueryParam(value="from") Date var4, @QueryParam(value="till") Date var5, @QueryParam(value="sort") String var6) throws IOException;

    @GET
    @Path(value="public/candles/{symbol}")
    public List<HitbtcCandle> getHitbtcOHLC(@PathParam(value="symbol") String var1, @QueryParam(value="limit") int var2, @QueryParam(value="period") String var3, @QueryParam(value="offset") int var4, @QueryParam(value="sort") String var5) throws IOException;
}

