/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinfloor.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinfloor.CoinfloorAdapters;
import org.knowm.xchange.coinfloor.dto.trade.CoinfloorOrder;
import org.knowm.xchange.coinfloor.dto.trade.CoinfloorUserTransaction;
import org.knowm.xchange.coinfloor.service.CoinfloorOpenOrdersParams;
import org.knowm.xchange.coinfloor.service.CoinfloorTradeHistoryParams;
import org.knowm.xchange.coinfloor.service.CoinfloorTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamMultiCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamMultiCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamMultiInstrument;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class CoinfloorTradeService
extends CoinfloorTradeServiceRaw
implements TradeService {
    private static final CurrencyPair NO_CURRENCY_PAIR = null;
    private static final Collection<CurrencyPair> NO_CURRENCY_PAIR_COLLECTION = Collections.emptySet();
    private static final Collection<Instrument> NO_INSTRUMENT_COLLECTION = Collections.emptySet();
    private final Collection<Instrument> allConfiguredCurrencyPairs;

    public CoinfloorTradeService(Exchange exchange) {
        super(exchange);
        this.allConfiguredCurrencyPairs = exchange.getExchangeMetaData().getInstruments().keySet();
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(NO_CURRENCY_PAIR, this.allConfiguredCurrencyPairs);
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        CurrencyPair pair = params instanceof OpenOrdersParamCurrencyPair ? ((OpenOrdersParamCurrencyPair)params).getCurrencyPair() : NO_CURRENCY_PAIR;
        Collection pairs = params instanceof OpenOrdersParamMultiCurrencyPair ? ((OpenOrdersParamMultiInstrument)params).getInstruments() : NO_INSTRUMENT_COLLECTION;
        return this.getOpenOrders(pair, pairs);
    }

    private OpenOrders getOpenOrders(CurrencyPair pair, Collection<Instrument> pairs) throws IOException {
        ArrayList<CoinfloorOrder> orders = new ArrayList<CoinfloorOrder>();
        if (pair == NO_CURRENCY_PAIR) {
            if (pairs.isEmpty()) {
                pairs = this.allConfiguredCurrencyPairs;
            }
        } else {
            CoinfloorOrder[] orderArray;
            for (CoinfloorOrder order : orderArray = this.getOpenOrders(pair)) {
                order.setCurrencyPair(pair);
                orders.add(order);
            }
        }
        for (Instrument currencyPair : pairs) {
            CoinfloorOrder[] orderArray;
            for (CoinfloorOrder order : orderArray = this.getOpenOrders((CurrencyPair)currencyPair)) {
                order.setCurrencyPair((CurrencyPair)currencyPair);
                orders.add(order);
            }
        }
        return CoinfloorAdapters.adaptOpenOrders(orders);
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new CoinfloorOpenOrdersParams();
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        Integer limit = params instanceof TradeHistoryParamPaging ? ((TradeHistoryParamPaging)params).getPageLength() : null;
        Long offset = params instanceof TradeHistoryParamOffset ? ((TradeHistoryParamOffset)params).getOffset() : null;
        TradeHistoryParamsSorted.Order sort = params instanceof TradeHistoryParamsSorted ? ((TradeHistoryParamsSorted)params).getOrder() : null;
        CurrencyPair pair = params instanceof TradeHistoryParamCurrencyPair ? ((TradeHistoryParamCurrencyPair)params).getCurrencyPair() : NO_CURRENCY_PAIR;
        Collection pairs = params instanceof TradeHistoryParamMultiCurrencyPair ? ((TradeHistoryParamMultiCurrencyPair)params).getCurrencyPairs() : NO_CURRENCY_PAIR_COLLECTION;
        ArrayList<CoinfloorUserTransaction> transactions = new ArrayList<CoinfloorUserTransaction>();
        if (pair == NO_CURRENCY_PAIR) {
            if (pairs.isEmpty()) {
                this.allConfiguredCurrencyPairs.forEach(instrument -> pairs.add((CurrencyPair)instrument));
            }
            for (Instrument currencyPair : pairs) {
                transactions.addAll(Arrays.asList(this.getUserTransactions(currencyPair, limit, offset, sort)));
            }
        } else {
            transactions.addAll(Arrays.asList(this.getUserTransactions((Instrument)pair, limit, offset, sort)));
        }
        return CoinfloorAdapters.adaptTradeHistory(transactions);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new CoinfloorTradeHistoryParams();
    }

    public String placeLimitOrder(LimitOrder order) throws IOException {
        CoinfloorOrder rawOrder = this.placeLimitOrder(order.getCurrencyPair(), order.getType(), order.getOriginalAmount(), order.getLimitPrice());
        return Long.toString(rawOrder.getId());
    }

    public String placeMarketOrder(MarketOrder order) throws IOException {
        this.placeMarketOrder(order.getCurrencyPair(), order.getType(), order.getOriginalAmount());
        return "";
    }

    public boolean cancelOrder(String orderId) throws IOException {
        CurrencyPair currencyPairValueIsIgnored = CurrencyPair.BTC_GBP;
        return this.cancelOrder(currencyPairValueIsIgnored, Long.parseLong(orderId));
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }
}

