/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinfloor.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class CoinfloorUserTransaction {
    public String datetime = "";
    public long id = 0L;
    @JsonProperty(value="order_id")
    public long orderId = 0L;
    public TransactionType type = TransactionType.UNKNOWN;
    public BigDecimal fee = BigDecimal.ZERO;
    @JsonProperty(value="xbt")
    public BigDecimal btc = BigDecimal.ZERO;
    public BigDecimal gbp = BigDecimal.ZERO;
    public BigDecimal usd = BigDecimal.ZERO;
    public BigDecimal eur = BigDecimal.ZERO;
    public BigDecimal eth = BigDecimal.ZERO;
    public BigDecimal ltc = BigDecimal.ZERO;
    public BigDecimal bch = BigDecimal.ZERO;
    public BigDecimal xrp = BigDecimal.ZERO;
    @JsonProperty(value="xbt_gbp")
    public BigDecimal btc_gbp = BigDecimal.ZERO;
    @JsonProperty(value="xbt_usd")
    public BigDecimal btc_usd = BigDecimal.ZERO;
    @JsonProperty(value="xbt_eur")
    public BigDecimal btc_eur = BigDecimal.ZERO;
    @JsonProperty(value="bch_gbp")
    public BigDecimal bch_gbp = BigDecimal.ZERO;
    @JsonProperty(value="eth_gbp")
    public BigDecimal eth_gbp = BigDecimal.ZERO;
    @JsonProperty(value="xrp_gbp")
    public BigDecimal xrp_gbp = BigDecimal.ZERO;
    @JsonProperty(value="ltc_gbp")
    public BigDecimal ltc_gbp = BigDecimal.ZERO;

    public CurrencyPair getCurrencyPair() {
        if (this.isTrade()) {
            if (!Objects.equals(this.btc_gbp, BigDecimal.ZERO)) {
                return CurrencyPair.BTC_GBP;
            }
            if (!Objects.equals(this.btc_usd, BigDecimal.ZERO)) {
                return CurrencyPair.BTC_USD;
            }
            if (!Objects.equals(this.btc_eur, BigDecimal.ZERO)) {
                return CurrencyPair.BTC_EUR;
            }
            if (!Objects.equals(this.bch_gbp, BigDecimal.ZERO)) {
                return CurrencyPair.BCH_GBP;
            }
            if (!Objects.equals(this.eth_gbp, BigDecimal.ZERO)) {
                return CurrencyPair.ETH_GBP;
            }
            if (!Objects.equals(this.xrp_gbp, BigDecimal.ZERO)) {
                return CurrencyPair.XRP_GBP;
            }
            if (!Objects.equals(this.ltc_gbp, BigDecimal.ZERO)) {
                return CurrencyPair.LTC_GBP;
            }
        }
        return null;
    }

    public BigDecimal getPrice() {
        if (this.isTrade()) {
            if (!Objects.equals(this.btc_gbp, BigDecimal.ZERO)) {
                return this.btc_gbp;
            }
            if (!Objects.equals(this.btc_usd, BigDecimal.ZERO)) {
                return this.btc_usd;
            }
            if (!Objects.equals(this.btc_eur, BigDecimal.ZERO)) {
                return this.btc_eur;
            }
            if (!Objects.equals(this.bch_gbp, BigDecimal.ZERO)) {
                return this.bch_gbp;
            }
            if (!Objects.equals(this.eth_gbp, BigDecimal.ZERO)) {
                return this.eth_gbp;
            }
            if (!Objects.equals(this.xrp_gbp, BigDecimal.ZERO)) {
                return this.xrp_gbp;
            }
            if (!Objects.equals(this.ltc_gbp, BigDecimal.ZERO)) {
                return this.ltc_gbp;
            }
        }
        return BigDecimal.ZERO;
    }

    public Currency getCurrency() {
        if (this.isTrade()) {
            return null;
        }
        if (this.btc.signum() != 0) {
            return Currency.BTC;
        }
        if (this.gbp.signum() != 0) {
            return Currency.GBP;
        }
        if (this.usd.signum() != 0) {
            return Currency.USD;
        }
        if (this.eur.signum() != 0) {
            return Currency.EUR;
        }
        if (this.ltc.signum() != 0) {
            return Currency.LTC;
        }
        if (this.eth.signum() != 0) {
            return Currency.ETH;
        }
        if (this.bch.signum() != 0) {
            return Currency.BCH;
        }
        if (this.xrp.signum() != 0) {
            return Currency.XRP;
        }
        return null;
    }

    public BigDecimal getAmount() {
        if (this.isTrade()) {
            if (this.getCurrencyPair().base == Currency.BTC) {
                return this.btc;
            }
            if (this.getCurrencyPair().base == Currency.XRP) {
                return this.xrp;
            }
            if (this.getCurrencyPair().base == Currency.LTC) {
                return this.ltc;
            }
            if (this.getCurrencyPair().base == Currency.ETH) {
                return this.eth;
            }
            if (this.getCurrencyPair().base == Currency.BCH) {
                return this.bch;
            }
            return BigDecimal.ZERO;
        }
        if (this.btc.signum() != 0) {
            return this.btc;
        }
        if (this.bch.signum() != 0) {
            return this.bch;
        }
        if (this.xrp.signum() != 0) {
            return this.xrp;
        }
        if (this.ltc.signum() != 0) {
            return this.ltc;
        }
        if (this.eth.signum() != 0) {
            return this.eth;
        }
        if (this.gbp.signum() != 0) {
            return this.gbp;
        }
        if (this.usd.signum() != 0) {
            return this.usd;
        }
        if (this.eur.signum() != 0) {
            return this.eur;
        }
        return BigDecimal.ZERO;
    }

    public Order.OrderType getSide() {
        if (this.isTrade()) {
            switch (this.getAmount().signum()) {
                default: {
                    return null;
                }
                case 1: {
                    return Order.OrderType.BID;
                }
                case -1: 
            }
            return Order.OrderType.ASK;
        }
        return null;
    }

    public boolean isDeposit() {
        return this.type == TransactionType.DEPOSIT;
    }

    public boolean isWithdrawal() {
        return this.type == TransactionType.WITHDRAWAL;
    }

    public boolean isTrade() {
        return this.type == TransactionType.TRADE;
    }

    public TransactionType getType() {
        return this.type;
    }

    public String getDateTime() {
        return this.datetime;
    }

    public long getId() {
        return this.id;
    }

    public long getOrderId() {
        return this.orderId;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public String toString() {
        if (this.isTrade()) {
            return String.format("CoinfloorUserTransaction{datetime=%s, id=%d, orderId=%d, type=%s, currencyPair=%s side=%s amount=%s price=%s fee=%s}", new Object[]{this.datetime, this.id, this.orderId, this.type, this.getCurrencyPair(), this.getSide(), this.getAmount(), this.getPrice(), this.fee});
        }
        return String.format("CoinfloorUserTransaction{datetime=%s, id=%d, type=%s, currency=%s amount=%s }", new Object[]{this.datetime, this.id, this.type, this.getCurrency(), this.getAmount()});
    }

    public static enum TransactionType {
        DEPOSIT,
        WITHDRAWAL,
        TRADE,
        UNKNOWN;

    }

    public static class CoinfloorTransactionTypeDeserializer
    extends JsonDeserializer<TransactionType> {
        public TransactionType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            switch (jp.getValueAsInt()) {
                case 0: {
                    return TransactionType.DEPOSIT;
                }
                case 1: {
                    return TransactionType.WITHDRAWAL;
                }
                case 2: {
                    return TransactionType.TRADE;
                }
            }
            return TransactionType.UNKNOWN;
        }
    }
}

