/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinfloor.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class CoinfloorOrder {
    private final long id;
    private final String datetime;
    private final int type;
    private final BigDecimal price;
    private final BigDecimal amount;
    private CurrencyPair pair = null;

    public CoinfloorOrder(@JsonProperty(value="status") String status, @JsonProperty(value="reason") Object reason, @JsonProperty(value="id") int id, @JsonProperty(value="datetime") String datetime, @JsonProperty(value="type") int type, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount) {
        this.id = id;
        this.datetime = datetime;
        this.type = type;
        this.price = price;
        this.amount = amount;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public long getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public Order.OrderType getSide() {
        switch (this.type) {
            case 0: {
                return Order.OrderType.BID;
            }
            case 1: {
                return Order.OrderType.ASK;
            }
        }
        return null;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public CurrencyPair getCurrencyPair() {
        return this.pair;
    }

    public void setCurrencyPair(CurrencyPair value) {
        this.pair = value;
    }

    public String toString() {
        return String.format("Order{id=%s, datetime=%s, side=%s, price=%s, amount=%s}", this.id, this.datetime, this.getSide(), this.price, this.amount);
    }
}

