/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinfloor.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Objects;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.Balance;

public class CoinfloorBalance {
    @JsonProperty(value="gbp_balance")
    public BigDecimal gbpBalance = BigDecimal.ZERO;
    @JsonProperty(value="usd_balance")
    public BigDecimal usdBalance = BigDecimal.ZERO;
    @JsonProperty(value="eur_balance")
    public BigDecimal eurBalance = BigDecimal.ZERO;
    @JsonProperty(value="xbt_balance")
    public BigDecimal btcBalance = BigDecimal.ZERO;
    @JsonProperty(value="bch_balance")
    public BigDecimal bchBalance = BigDecimal.ZERO;
    @JsonProperty(value="eth_balance")
    public BigDecimal ethBalance = BigDecimal.ZERO;
    @JsonProperty(value="ltc_balance")
    public BigDecimal ltcBalance = BigDecimal.ZERO;
    @JsonProperty(value="xrp_balance")
    public BigDecimal xrpBalance = BigDecimal.ZERO;
    @JsonProperty(value="gbp_reserved")
    public BigDecimal gbpReserved = BigDecimal.ZERO;
    @JsonProperty(value="usd_reserved")
    public BigDecimal usdReserved = BigDecimal.ZERO;
    @JsonProperty(value="eur_reserved")
    public BigDecimal eurReserved = BigDecimal.ZERO;
    @JsonProperty(value="xbt_reserved")
    public BigDecimal btcReserved = BigDecimal.ZERO;
    @JsonProperty(value="bch_reserved")
    public BigDecimal bchReserved = BigDecimal.ZERO;
    @JsonProperty(value="eth_reserved")
    public BigDecimal ethReserved = BigDecimal.ZERO;
    @JsonProperty(value="ltc_reserved")
    public BigDecimal ltcReserved = BigDecimal.ZERO;
    @JsonProperty(value="xrp_reserved")
    public BigDecimal xrpReserved = BigDecimal.ZERO;
    @JsonProperty(value="gbp_available")
    public BigDecimal gbpAvailable = BigDecimal.ZERO;
    @JsonProperty(value="usd_available")
    public BigDecimal usdAvailable = BigDecimal.ZERO;
    @JsonProperty(value="eur_available")
    public BigDecimal eurAvailable = BigDecimal.ZERO;
    @JsonProperty(value="xbt_available")
    public BigDecimal btcAvailable = BigDecimal.ZERO;
    @JsonProperty(value="bch_available")
    public BigDecimal bchAvailable = BigDecimal.ZERO;
    @JsonProperty(value="eth_available")
    public BigDecimal ethAvailable = BigDecimal.ZERO;
    @JsonProperty(value="ltc_available")
    public BigDecimal ltcAvailable = BigDecimal.ZERO;
    @JsonProperty(value="xrp_available")
    public BigDecimal xrpAvailable = BigDecimal.ZERO;

    public boolean hasCurrency(Currency currency) {
        if (currency.equals((Object)Currency.BTC)) {
            return !Objects.equals(this.btcBalance, BigDecimal.ZERO);
        }
        if (currency.equals((Object)Currency.GBP)) {
            return !Objects.equals(this.gbpBalance, BigDecimal.ZERO);
        }
        if (currency.equals((Object)Currency.EUR)) {
            return !Objects.equals(this.eurBalance, BigDecimal.ZERO);
        }
        if (currency.equals((Object)Currency.USD)) {
            return !Objects.equals(this.usdBalance, BigDecimal.ZERO);
        }
        if (currency.equals((Object)Currency.BCH)) {
            return !Objects.equals(this.bchBalance, BigDecimal.ZERO);
        }
        if (currency.equals((Object)Currency.XRP)) {
            return !Objects.equals(this.xrpBalance, BigDecimal.ZERO);
        }
        if (currency.equals((Object)Currency.LTC)) {
            return !Objects.equals(this.ltcBalance, BigDecimal.ZERO);
        }
        if (currency.equals((Object)Currency.ETH)) {
            return !Objects.equals(this.ethBalance, BigDecimal.ZERO);
        }
        return false;
    }

    public Balance getBalance(Currency currency) {
        if (currency.equals((Object)Currency.XBT)) {
            return new Balance(currency, this.btcBalance, this.btcAvailable, this.btcReserved);
        }
        if (currency.equals((Object)Currency.GBP)) {
            return new Balance(currency, this.gbpBalance, this.gbpAvailable, this.gbpReserved);
        }
        if (currency.equals((Object)Currency.EUR)) {
            return new Balance(currency, this.eurBalance, this.eurAvailable, this.eurReserved);
        }
        if (currency.equals((Object)Currency.USD)) {
            return new Balance(currency, this.usdBalance, this.usdAvailable, this.usdReserved);
        }
        if (currency.equals((Object)Currency.BCH)) {
            return new Balance(currency, this.bchBalance, this.bchAvailable, this.bchReserved);
        }
        if (currency.equals((Object)Currency.XRP)) {
            return new Balance(currency, this.xrpBalance, this.xrpAvailable, this.xrpReserved);
        }
        if (currency.equals((Object)Currency.LTC)) {
            return new Balance(currency, this.ltcBalance, this.ltcAvailable, this.ltcReserved);
        }
        if (currency.equals((Object)Currency.ETH)) {
            return new Balance(currency, this.ethBalance, this.ethAvailable, this.ethReserved);
        }
        throw new IllegalArgumentException("Unsupported currency: " + currency);
    }
}

