/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinfloor;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.coinfloor.dto.CoinfloorException;
import org.knowm.xchange.coinfloor.dto.account.CoinfloorBalance;
import org.knowm.xchange.coinfloor.dto.trade.CoinfloorMarketOrderResponse;
import org.knowm.xchange.coinfloor.dto.trade.CoinfloorOrder;
import org.knowm.xchange.coinfloor.dto.trade.CoinfloorUserTransaction;
import org.knowm.xchange.currency.Currency;

@Path(value="bist")
@Produces(value={"application/json"})
public interface CoinfloorAuthenticated {
    @GET
    @Path(value="{base}/{counter}/balance/")
    public CoinfloorBalance getBalance(@PathParam(value="base") Currency var1, @PathParam(value="counter") Currency var2) throws CoinfloorException, IOException;

    @GET
    @Path(value="{base}/{counter}/user_transactions/")
    public CoinfloorUserTransaction[] getUserTransactions(@PathParam(value="base") Currency var1, @PathParam(value="counter") Currency var2, @FormParam(value="limit") Integer var3, @FormParam(value="offset") Long var4, @FormParam(value="sort") String var5) throws CoinfloorException, IOException;

    @GET
    @Path(value="{base}/{counter}/open_orders/")
    public CoinfloorOrder[] getOpenOrders(@PathParam(value="base") Currency var1, @PathParam(value="counter") Currency var2) throws CoinfloorException, IOException;

    @GET
    @Path(value="{base}/{counter}/buy/")
    public CoinfloorOrder buy(@PathParam(value="base") Currency var1, @PathParam(value="counter") Currency var2, @FormParam(value="amount") BigDecimal var3, @FormParam(value="price") BigDecimal var4) throws CoinfloorException, IOException;

    @GET
    @Path(value="{base}/{counter}/buy_market/")
    public CoinfloorMarketOrderResponse buyMarket(@PathParam(value="base") Currency var1, @PathParam(value="counter") Currency var2, @FormParam(value="quantity") BigDecimal var3) throws CoinfloorException, IOException;

    @GET
    @Path(value="{base}/{counter}/sell/")
    public CoinfloorOrder sell(@PathParam(value="base") Currency var1, @PathParam(value="counter") Currency var2, @FormParam(value="amount") BigDecimal var3, @FormParam(value="price") BigDecimal var4) throws CoinfloorException, IOException;

    @GET
    @Path(value="{base}/{counter}/sell_market/")
    public CoinfloorMarketOrderResponse sellMarket(@PathParam(value="base") Currency var1, @PathParam(value="counter") Currency var2, @FormParam(value="quantity") BigDecimal var3) throws CoinfloorException, IOException;

    @GET
    @Path(value="{base}/{counter}/cancel_order/")
    public boolean cancelOrder(@PathParam(value="base") Currency var1, @PathParam(value="counter") Currency var2, @FormParam(value="id") long var3) throws CoinfloorException, IOException;
}

