/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinfloor.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinfloor.dto.trade.CoinfloorMarketOrderResponse;
import org.knowm.xchange.coinfloor.dto.trade.CoinfloorOrder;
import org.knowm.xchange.coinfloor.dto.trade.CoinfloorUserTransaction;
import org.knowm.xchange.coinfloor.service.CoinfloorAuthenticatedService;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import si.mazi.rescu.HttpStatusIOException;

public class CoinfloorTradeServiceRaw
extends CoinfloorAuthenticatedService {
    protected CoinfloorTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public CoinfloorUserTransaction[] getUserTransactions(Instrument pair, Integer numberOfTransactions, Long offset, TradeHistoryParamsSorted.Order sort) throws IOException {
        try {
            return this.coinfloor.getUserTransactions(this.normalise(pair.getBase()), this.normalise(pair.getCounter()), numberOfTransactions, offset, sort == null ? null : sort.toString());
        }
        catch (HttpStatusIOException e) {
            if (e.getHttpStatusCode() == 400) {
                throw new ExchangeException(e.getHttpBody(), (Throwable)e);
            }
            throw e;
        }
    }

    public CoinfloorOrder[] getOpenOrders(CurrencyPair pair) throws IOException {
        try {
            return this.coinfloor.getOpenOrders(this.normalise(pair.base), this.normalise(pair.counter));
        }
        catch (HttpStatusIOException e) {
            if (e.getHttpStatusCode() == 400) {
                throw new ExchangeException(e.getHttpBody(), (Throwable)e);
            }
            throw e;
        }
    }

    public CoinfloorOrder placeLimitOrder(CurrencyPair pair, Order.OrderType side, BigDecimal amount, BigDecimal price) throws IOException {
        Currency base = this.normalise(pair.base);
        Currency counter = this.normalise(pair.counter);
        try {
            if (side == Order.OrderType.BID) {
                return this.coinfloor.buy(base, counter, amount, price);
            }
            return this.coinfloor.sell(base, counter, amount, price);
        }
        catch (HttpStatusIOException e) {
            if (e.getHttpStatusCode() == 400) {
                throw new ExchangeException(e.getHttpBody(), (Throwable)e);
            }
            throw e;
        }
    }

    public CoinfloorMarketOrderResponse placeMarketOrder(CurrencyPair pair, Order.OrderType side, BigDecimal amount) throws IOException {
        Currency base = this.normalise(pair.base);
        Currency counter = this.normalise(pair.counter);
        try {
            if (side == Order.OrderType.BID) {
                return this.coinfloor.buyMarket(base, counter, amount);
            }
            return this.coinfloor.sellMarket(base, counter, amount);
        }
        catch (HttpStatusIOException e) {
            if (e.getHttpStatusCode() == 400) {
                throw new ExchangeException(e.getHttpBody(), (Throwable)e);
            }
            throw e;
        }
    }

    public boolean cancelOrder(CurrencyPair pair, long id) throws IOException {
        try {
            return this.coinfloor.cancelOrder(this.normalise(pair.base), this.normalise(pair.counter), id);
        }
        catch (HttpStatusIOException e) {
            if (e.getHttpStatusCode() == 400) {
                throw new ExchangeException(e.getHttpBody(), (Throwable)e);
            }
            throw e;
        }
    }
}

