/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinfloor.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.coinfloor.CoinfloorPublic;
import org.knowm.xchange.coinfloor.dto.markedata.CoinfloorOrderBook;
import org.knowm.xchange.coinfloor.dto.markedata.CoinfloorTicker;
import org.knowm.xchange.coinfloor.dto.markedata.CoinfloorTransaction;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.service.BaseExchangeService;

public class CoinfloorMarketDataServiceRaw
extends BaseExchangeService {
    private final CoinfloorPublic coinfloor;

    protected CoinfloorMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.coinfloor = (CoinfloorPublic)ExchangeRestProxyBuilder.forInterface(CoinfloorPublic.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
    }

    public CoinfloorTicker getCoinfloorTicker(CurrencyPair pair) throws IOException {
        return this.coinfloor.getTicker(this.normalise(pair.base), this.normalise(pair.counter));
    }

    public CoinfloorOrderBook getCoinfloorOrderBook(CurrencyPair pair) throws IOException {
        return this.coinfloor.getOrderBook(this.normalise(pair.base), this.normalise(pair.counter));
    }

    public CoinfloorTransaction[] getCoinfloorTransactions(CurrencyPair pair, CoinfloorInterval interval) throws IOException {
        return this.coinfloor.getTransactions(this.normalise(pair.base), this.normalise(pair.counter), interval);
    }

    private Currency normalise(Currency xchange) {
        if (xchange == Currency.BTC) {
            return Currency.XBT;
        }
        return xchange;
    }

    public static enum CoinfloorInterval {
        DAY,
        HOUR,
        MINUTE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

