/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinfloor.service;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ClientConfigCustomizer;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.coinfloor.CoinfloorAuthenticated;
import org.knowm.xchange.coinfloor.service.CoinfloorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.ClientConfigUtil;

public class CoinfloorAuthenticatedService
extends CoinfloorService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected CoinfloorAuthenticated coinfloor;

    protected CoinfloorAuthenticatedService(Exchange exchange) {
        super(exchange);
        ExchangeSpecification specification = exchange.getExchangeSpecification();
        if (specification.getUserName() == null || specification.getPassword() == null) {
            this.logger.info("Authenticated endpoints are not available - username and password have not been configured");
            this.coinfloor = null;
            return;
        }
        ClientConfigCustomizer clientConfigCustomizer = config -> ClientConfigUtil.addBasicAuthCredentials((ClientConfig)config, (String)specification.getUserName(), (String)specification.getPassword());
        this.coinfloor = (CoinfloorAuthenticated)ExchangeRestProxyBuilder.forInterface(CoinfloorAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).clientConfigCustomizer(clientConfigCustomizer).build();
    }
}

