/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinfloor.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinfloor.CoinfloorAdapters;
import org.knowm.xchange.coinfloor.dto.account.CoinfloorBalance;
import org.knowm.xchange.coinfloor.service.CoinfloorAccountServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class CoinfloorAccountService
extends CoinfloorAccountServiceRaw
implements AccountService {
    public CoinfloorAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        ArrayList<CoinfloorBalance> rawBalances = new ArrayList<CoinfloorBalance>();
        for (Instrument pair : this.exchange.getExchangeInstruments()) {
            CoinfloorBalance balance = this.getCoinfloorBalance(pair);
            rawBalances.add(balance);
        }
        return CoinfloorAdapters.adaptAccountInfo(this.exchange.getExchangeMetaData().getCurrencies().keySet(), rawBalances);
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws NotAvailableFromExchangeException {
        throw new NotAvailableFromExchangeException();
    }

    public String withdrawFunds(WithdrawFundsParams params) {
        throw new NotAvailableFromExchangeException();
    }

    public String requestDepositAddress(Currency currency, String ... args) throws NotAvailableFromExchangeException {
        throw new NotAvailableFromExchangeException();
    }
}

