/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.maven.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ossindex.common.IPackageRequest;
import net.ossindex.common.OssIndexApi;
import net.ossindex.common.PackageDescriptor;
import net.ossindex.maven.utils.MavenIdWrapper;
import net.ossindex.maven.utils.MavenPackageDescriptor;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

public class DependencyAuditor {
    private Map<PackageDescriptor, PackageDescriptor> parents = new HashMap<PackageDescriptor, PackageDescriptor>();
    private IPackageRequest request = OssIndexApi.createPackageRequest();
    private RepositorySystem repoSystem;
    private RepositorySystemSession session;

    DependencyAuditor() {
    }

    public DependencyAuditor(RepositorySystem repoSystem, RepositorySystemSession session) {
        this.repoSystem = repoSystem;
        this.session = session;
    }

    public void add(String groupId, String artifactId, String version) {
        PackageDescriptor parent = this.request.add("maven", groupId, artifactId, version);
        this.parents.put(parent, null);
        this.addPackageDependencies(parent, groupId, artifactId, version);
    }

    private List<PackageDescriptor> addPackageDependencies(PackageDescriptor parent, String groupId, String artifactId, String version) {
        LinkedList<PackageDescriptor> packageDependency = new LinkedList<PackageDescriptor>();
        String aid = groupId + ":" + artifactId + ":";
        if (version != null) {
            aid = aid + version;
        }
        Dependency dependency = new Dependency((Artifact)new DefaultArtifact(aid), "compile");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        try {
            DependencyNode node = this.repoSystem.collectDependencies(this.session, collectRequest).getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            this.repoSystem.resolveDependencies(this.session, dependencyRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            List artifacts = nlg.getArtifacts(false);
            for (Artifact artifact : artifacts) {
                PackageDescriptor pkgDep = new PackageDescriptor("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                if (this.parents.containsKey(pkgDep)) continue;
                pkgDep = this.request.add("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                this.parents.put(pkgDep, parent);
                packageDependency.add(pkgDep);
            }
        }
        catch (DependencyCollectionException | DependencyResolutionException throwable) {
            // empty catch block
        }
        return packageDependency;
    }

    public Collection<MavenPackageDescriptor> run() throws IOException {
        LinkedList<MavenPackageDescriptor> results = new LinkedList<MavenPackageDescriptor>();
        Collection packages = this.request.run();
        for (PackageDescriptor pkg : packages) {
            MavenPackageDescriptor mvnPkg = new MavenPackageDescriptor(pkg);
            if (this.parents.containsKey(pkg)) {
                mvnPkg.setParent(new MavenIdWrapper(this.parents.get(pkg)));
            }
            results.add(mvnPkg);
        }
        return results;
    }

    public void close() {
    }
}

