/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.maven.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.ossindex.common.VulnerabilityDescriptor;
import net.ossindex.maven.utils.DependencyAuditor;
import net.ossindex.maven.utils.MavenIdWrapper;
import net.ossindex.maven.utils.MavenPackageDescriptor;
import net.ossindex.maven.utils.OssIndexResultsWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="audit")
public class OssIndexMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> projectRepos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="audit.ignore", defaultValue="")
    private String ignore;
    private Set<String> ignoreSet = new HashSet<String>();
    @Parameter(property="audit.failOnError", defaultValue="true")
    private String failOnError;
    @Parameter(property="audit.output", defaultValue="")
    private String output;
    private Set<File> outputFiles = new HashSet<File>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] tokens;
        if (this.ignore != null) {
            this.ignore = this.ignore.trim();
            if (!this.ignore.isEmpty()) {
                for (String token : tokens = this.ignore.split(",")) {
                    this.ignoreSet.add(token.trim());
                }
            }
        }
        if (this.output != null) {
            this.output = this.output.trim();
            if (!this.output.isEmpty()) {
                for (String token : tokens = this.output.split(",")) {
                    this.outputFiles.add(new File(token));
                }
            }
        }
        try (DependencyAuditor auditor = new DependencyAuditor(this.repoSystem, this.repoSession);){
            this.getLog().info((CharSequence)"OSS Index dependency audit");
            int failures = 0;
            List deps = this.project.getDependencies();
            for (Dependency dep : deps) {
                auditor.add(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
            }
            Collection<MavenPackageDescriptor> results = auditor.run();
            for (MavenPackageDescriptor pkg : results) {
                String idPkg = pkg.getMavenPackageId();
                String idVer = pkg.getMavenVersionId();
                if (this.ignoreSet.contains(idPkg) || this.ignoreSet.contains(idVer)) continue;
                MavenIdWrapper parentPkg = pkg.getParent();
                failures += this.report(parentPkg, pkg);
            }
            for (File file : this.outputFiles) {
                if (file.getName().endsWith(".txt")) {
                    this.exportTxt(file, results);
                }
                if (file.getName().endsWith(".json")) {
                    this.exportJson(file, results);
                }
                if (!file.getName().endsWith(".xml")) continue;
                this.exportXml(file, results);
            }
            if (failures > 0 && "true".equals(this.failOnError)) {
                throw new MojoFailureException(failures + " known vulnerabilities affecting project dependencies");
            }
        }
    }

    private void exportTxt(File file, Collection<MavenPackageDescriptor> results) {
    }

    private void exportJson(File file, Collection<MavenPackageDescriptor> results) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        String json = gson.toJson(results);
        try {
            FileUtils.writeStringToFile((File)file, (String)json);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Cannot export to " + file + ": " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportXml(File file, Collection<MavenPackageDescriptor> results) {
        OssIndexResultsWrapper wrapper = new OssIndexResultsWrapper(results);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{OssIndexResultsWrapper.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)wrapper, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            this.getLog().warn((CharSequence)("Cannot export to " + file + ": " + e.getMessage()));
        }
        catch (JAXBException e) {
            e.printStackTrace();
            this.getLog().warn((CharSequence)("Cannot export to " + file + ": " + e.getMessage()));
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Exception closing " + file + ": " + e.getMessage()));
                }
            }
        }
    }

    private int report(MavenIdWrapper parentPkg, MavenPackageDescriptor pkg) throws IOException {
        int failures = 0;
        String pkgId = pkg.getMavenVersionId();
        int total = pkg.getVulnerabilityTotal();
        List<VulnerabilityDescriptor> vulnerabilities = pkg.getVulnerabilities();
        if (vulnerabilities != null && !vulnerabilities.isEmpty()) {
            int matches = pkg.getVulnerabilityMatches();
            this.getLog().error((CharSequence)"");
            this.getLog().error((CharSequence)"--------------------------------------------------------------");
            this.getLog().error((CharSequence)(pkgId + "  [VULNERABLE]"));
            if (parentPkg != null) {
                String parentId = parentPkg.getMavenVersionId();
                this.getLog().error((CharSequence)("  required by " + parentId));
            }
            this.getLog().error((CharSequence)(total + " known vulnerabilities, " + matches + " affecting installed version"));
            this.getLog().error((CharSequence)"");
            for (VulnerabilityDescriptor vulnerability : vulnerabilities) {
                this.getLog().error((CharSequence)vulnerability.getTitle());
                this.getLog().error((CharSequence)vulnerability.getUriString());
                this.getLog().error((CharSequence)vulnerability.getDescription());
                this.getLog().error((CharSequence)"");
            }
            this.getLog().error((CharSequence)"--------------------------------------------------------------");
            this.getLog().error((CharSequence)"");
            failures += matches;
        } else if (total > 0) {
            this.getLog().info((CharSequence)(pkgId + ": " + total + " known vulnerabilities, 0 affecting installed version"));
        } else {
            this.getLog().info((CharSequence)(pkgId + ": No known vulnerabilities"));
        }
        return failures;
    }

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
    }
}

