/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.feature.itest.messaging.conf;

import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.Component;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.ops4j.pax.cdi.api.OsgiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CDIMessagingComponents {
    private static final Logger LOG = LoggerFactory.getLogger(CDIMessagingComponents.class);
    @Inject
    @OsgiService(filter="(component-type=jms)", dynamic=true)
    private transient Component jms;

    @Produces
    @Named(value="jms")
    public final Component getJms() {
        LOG.info("Inject jms route");
        return this.jms;
    }

    @Produces
    @Named(value="properties")
    PropertiesComponent properties(PropertiesParser parser) {
        PropertiesComponent component = new PropertiesComponent();
        component.setPropertiesParser(parser);
        return component;
    }

    static class DeltaSpikeParser
    extends DefaultPropertiesParser {
        DeltaSpikeParser() {
        }

        public String parseProperty(String key, String value, Properties properties) {
            return ConfigResolver.getPropertyValue((String)key);
        }
    }
}

