/*
 * Decompiled with CFR 0.152.
 */
package cicada.userdriver.proxy;

import cicada.userdriver.config.UserInfoService;
import cicada.userdriver.proxy.UserInfoProxy;
import cicada.userdriver.zooKeeper.ZooKeeperOperator;
import java.io.IOException;
import java.util.List;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.zookeeper.KeeperException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;

@Configuration
public class UserInfoFace {
    @Autowired
    Environment env;

    @Bean
    @Scope(scopeName="prototype")
    public UserInfoService.Iface GetUserInfo() throws IOException, InterruptedException, KeeperException {
        TSocket transport = null;
        String address = this.env.getProperty("Cicada.Rpc.Client.Endpoints.2.ServiceCentre.RespositoryServer");
        String nodeName = this.env.getProperty("Cicada.Rpc.Client.Endpoints.2.ServiceCentre.Name");
        ZooKeeperOperator zkoperator = new ZooKeeperOperator();
        zkoperator.connect(address);
        List<String> ipList = zkoperator.getChild(nodeName);
        if (ipList == null) {
            return null;
        }
        String ip = ipList.get(0).split(":")[0];
        String port = ipList.get(0).split(":")[1];
        transport = new TSocket(ip, Integer.parseInt(port), 2000);
        TCompactProtocol protocol = new TCompactProtocol((TTransport)transport);
        UserInfoProxy usinfoProxy = new UserInfoProxy();
        UserInfoService.Iface face = (UserInfoService.Iface)usinfoProxy.bind(new UserInfoService.Client((TProtocol)protocol), (TTransport)transport);
        return face;
    }
}

