package cicada.userdriver.zooKeeper;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;

public class ZooKeeperOperator extends AbstractZooKeeper
{
	private static Log log = LogFactory.getLog(ZooKeeperOperator.class.getName());

	public List<String>  getChild(String path) throws KeeperException, InterruptedException
	{
		try
		{
			List<String> list = this.zooKeeper.getChildren(path, false);
			if (list.isEmpty())
			{
				return null;
			}
			else
			{
				return list;
			}
		}
		catch (KeeperException.NoNodeException e)
		{
			throw e;
		}
		finally {
			this.close();
		}
	}
	
	private byte[] getData(String path) throws KeeperException, InterruptedException
	{
		return this.zooKeeper.getData(path, false, null);
	}
}
