package cicada.userdriver.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class UserInfoProxy implements InvocationHandler
{
	private Object targetObject;
	
	private TTransport transport =null;

	public Object bind(Object targetObject,TTransport transport)
	{
		this.transport=transport;
		this.targetObject = targetObject;
		return Proxy.newProxyInstance(targetObject.getClass().getClassLoader(), targetObject.getClass().getInterfaces(), this);
	}

	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
	{
		excuteBefore();
		Object ret = method.invoke(targetObject, args);
		excuteAfter();
		return ret;
	}
	
	 public  void excuteBefore() throws TTransportException
	{
		if(transport.isOpen()==false)
			transport.open();
	}
	
	public void excuteAfter()
	{
		if(transport!=null && transport.isOpen())
			transport.close();
	}
}
