package cicada.userdriver.proxy;

import java.io.IOException;
import java.util.List;

import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.zookeeper.KeeperException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;

import cicada.userdriver.config.UserInfoService.Iface;
import cicada.userdriver.zooKeeper.ZooKeeperOperator;

@Configuration
public class UserInfoFace
{
	@Autowired
	Environment env;

	@Bean
	@Scope(scopeName = "prototype")
	public Iface GetUserInfo() throws IOException, InterruptedException, KeeperException
	{
		TTransport transport = null;
		String address = env.getProperty("Cicada.Rpc.Client.Endpoints.2.ServiceCentre.RespositoryServer");
		String nodeName = env.getProperty("Cicada.Rpc.Client.Endpoints.2.ServiceCentre.Name");
		ZooKeeperOperator zkoperator = new ZooKeeperOperator();
		zkoperator.connect(address);
		List<String> ipList = zkoperator.getChild(nodeName);
		if (ipList == null) return null;
		String ip = ipList.get(0).split(":")[0];
		String port = ipList.get(0).split(":")[1];
		transport = new TSocket(ip, Integer.parseInt(port), 2000);
		TProtocol protocol = new TCompactProtocol(transport);
		UserInfoProxy usinfoProxy = new UserInfoProxy();
		Iface face = (Iface) usinfoProxy.bind(new cicada.userdriver.config.UserInfoService.Client(protocol), transport);
		return face;
	}
}
