/*
 * Decompiled with CFR 0.152.
 */
package cicada.thumbnail.video;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.Java2DFrameConverter;

public class ThumbVideo {
    public static byte[] frame2Img(InputStream videofile, String format, double scale) throws IOException {
        try (FFmpegFrameGrabber fFmpegFrameGrabber = new FFmpegFrameGrabber(videofile);){
            byte[] data;
            Frame frame = ThumbVideo.getFrame(fFmpegFrameGrabber);
            fFmpegFrameGrabber.stop();
            BufferedImage bufferedImage = null;
            if (scale == 1.0) {
                Java2DFrameConverter frame2buff = new Java2DFrameConverter();
                bufferedImage = frame2buff.convert(frame);
            } else {
                bufferedImage = ThumbVideo.scale(frame, scale);
            }
            byte[] byArray = data = ((DataBufferByte)bufferedImage.getData().getDataBuffer()).getData();
            return byArray;
        }
    }

    public static void frame2Img(InputStream videofile, String outImgName, String format, double scale) throws IOException {
        try (FFmpegFrameGrabber fFmpegFrameGrabber = new FFmpegFrameGrabber(videofile);){
            Frame frame = ThumbVideo.getFrame(fFmpegFrameGrabber);
            fFmpegFrameGrabber.stop();
            Java2DFrameConverter frame2buff = new Java2DFrameConverter();
            BufferedImage bufferedImage = null;
            bufferedImage = scale == 1.0 ? frame2buff.convert(frame) : ThumbVideo.scale(frame, scale);
            File out = new File(outImgName);
            ImageIO.write((RenderedImage)bufferedImage, format, out);
        }
    }

    private static Frame getFrame(FFmpegFrameGrabber fFmpegFrameGrabber) throws FrameGrabber.Exception {
        Frame frame = null;
        fFmpegFrameGrabber.start();
        int lenght = fFmpegFrameGrabber.getLengthInFrames();
        for (int frameNum = 0; frameNum < lenght; ++frameNum) {
            frame = fFmpegFrameGrabber.grabFrame();
            if (frameNum > 5 && frame.image != null) break;
        }
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage scale(Frame frame, double scale) {
        int width = (int)((double)frame.imageWidth * scale);
        int height = (int)((double)frame.imageHeight * scale);
        Java2DFrameConverter frame2buff = new Java2DFrameConverter();
        BufferedImage src = frame2buff.convert(frame);
        Image imgage = src.getScaledInstance(width, height, 2);
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        try {
            boolean result = graphics.drawImage(imgage, 0, 0, null);
            if (result) {
                BufferedImage bufferedImage2 = bufferedImage;
                return bufferedImage2;
            }
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return null;
    }
}

