package cicada.thumbnail.video;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import javax.imageio.ImageIO;

import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber.Exception;
import org.bytedeco.javacv.Java2DFrameConverter;

public class ThumbVideo
{

	/**
	 * @param videofile:视频文件
	 * @param format:图片文件的格式,例如"png,jpg等"
	 * @param scale:图片的缩放比例.例如 0.3,0.5等.1不缩放
	 * @return
	 * @throws IOException
	 */
	public static byte[] frame2Img(InputStream videofile, String format, double scale) throws IOException
	{

		try (FFmpegFrameGrabber fFmpegFrameGrabber = new FFmpegFrameGrabber(videofile))
		{
			Frame frame = getFrame(fFmpegFrameGrabber);
			fFmpegFrameGrabber.stop();

			BufferedImage bufferedImage = null;
			if (scale == 1)
			{
				Java2DFrameConverter frame2buff = new Java2DFrameConverter();
				bufferedImage = frame2buff.convert(frame);
			}
			else
			{
				bufferedImage = scale(frame, scale);
			}

			byte[] data = ((DataBufferByte) bufferedImage.getData().getDataBuffer()).getData();
			return data;
		}
	}

	/**
	 * @param videofile:视频文件
	 * @param outImgName:保存的图片文件
	 * @param format:图片文件的格式,例如"png,jpg等"
	 * @param scale:图片的缩放比例.例如 0.3,0.5等.1不缩放
	 * @throws IOException
	 */
	public static void frame2Img(InputStream videofile, String outImgName, String format, double scale) throws IOException
	{
		try (FFmpegFrameGrabber fFmpegFrameGrabber = new FFmpegFrameGrabber(videofile))
		{
			Frame frame = getFrame(fFmpegFrameGrabber);
			fFmpegFrameGrabber.stop();
			Java2DFrameConverter frame2buff = new Java2DFrameConverter();
			BufferedImage bufferedImage = null;

			if (scale == 1)
			{
				bufferedImage = frame2buff.convert(frame);
			}
			else
			{
				bufferedImage = scale(frame, scale);
			}

			File out = new File(outImgName);
			ImageIO.write(bufferedImage, format, out);
		}
	}

	private static Frame getFrame(FFmpegFrameGrabber fFmpegFrameGrabber) throws Exception
	{
		Frame frame = null;
		fFmpegFrameGrabber.start();
		int lenght = fFmpegFrameGrabber.getLengthInFrames();

		int frameNum = 0;
		while (frameNum < lenght)
		{
			frame = fFmpegFrameGrabber.grabFrame();
			if ((frameNum > 5) && (frame.image != null))
			{
				break;
			}
			frameNum++;
		}

		return frame;
	}

	private static BufferedImage scale(Frame frame, double scale)
	{
		int width = (int) (frame.imageWidth * scale);
		int height = (int) (frame.imageHeight * scale);

		Java2DFrameConverter frame2buff = new Java2DFrameConverter();
		BufferedImage src = frame2buff.convert(frame);
		Image imgage = src.getScaledInstance(width, height, Image.SCALE_FAST);

		BufferedImage bufferedImage = new BufferedImage(width, height, Image.SCALE_FAST);
		Graphics graphics = bufferedImage.getGraphics();
		try
		{
			boolean result = graphics.drawImage(imgage, 0, 0, null);
			if (result)
			{
				return bufferedImage;
			}
		}
		finally
		{
			if (graphics != null)
			{
				graphics.dispose();
			}
		}
		return null;
	}
}
