package cicada.swagger.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import com.google.common.collect.Lists;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@EnableWebMvc
@Configuration
public class SwaggerConfiguration
{
	@Autowired
	Environment env;

	@Bean
	public Docket api()
	{
		String title = env.getProperty("swagger.title");
		String description = env.getProperty("swagger.description");
		String version = env.getProperty("swagger.version");
		Docket docket = new Docket(DocumentationType.SWAGGER_2).select().paths(PathSelectors.any()).build();

		//ApiInfo info1=new ApiInfo(title, description, version, termsOfServiceUrl, contactName, license, licenseUrl)
		@SuppressWarnings("deprecation")
		ApiInfo info = new ApiInfo(title, description, version, "", "","","");
		docket.apiInfo(info).securitySchemes(Lists.newArrayList(apiKey())).genericModelSubstitutes(ResponseEntity.class);
		return docket;
	}

	private ApiKey apiKey()
	{
		return new ApiKey("Authentication", "api_key", "header");
	}
}
