/*
 * Decompiled with CFR 0.152.
 */
package cicada.swagger.config;

import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@EnableWebMvc
@Configuration
public class SwaggerConfiguration {
    @Autowired
    Environment env;

    @Bean
    public Docket api() {
        String title = this.env.getProperty("swagger.title");
        String description = this.env.getProperty("swagger.description");
        String version = this.env.getProperty("swagger.version");
        Docket docket = new Docket(DocumentationType.SWAGGER_2).select().paths(PathSelectors.any()).build();
        ApiInfo info = new ApiInfo(title, description, version, "", new Contact("", "", ""), "", "");
        docket.apiInfo(info).securitySchemes((List)Lists.newArrayList((Object[])new ApiKey[]{this.apiKey()})).genericModelSubstitutes(new Class[]{ResponseEntity.class});
        return docket;
    }

    private ApiKey apiKey() {
        return new ApiKey("Authentication", "api_key", "header");
    }
}

